/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.variables.delta;

import org.chocosolver.graphsolver.variables.GraphEventType;
import org.chocosolver.graphsolver.variables.delta.GraphDelta;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.TimeStampedObject;
import org.chocosolver.solver.variables.delta.IDeltaMonitor;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.procedure.PairProcedure;

public class GraphDeltaMonitor
extends TimeStampedObject
implements IDeltaMonitor {
    private final GraphDelta delta;
    private int[] first;
    private int[] last;
    private int[] frozenFirst;
    private int[] frozenLast;
    private ICause propagator;

    public GraphDeltaMonitor(GraphDelta delta, ICause propagator) {
        super(delta.getEnvironment());
        this.delta = delta;
        this.first = new int[4];
        this.last = new int[4];
        this.frozenFirst = new int[4];
        this.frozenLast = new int[4];
        this.propagator = propagator;
    }

    public void freeze() {
        int i;
        if (this.needReset()) {
            for (i = 0; i < 4; ++i) {
                this.last[i] = 0;
                this.first[i] = 0;
            }
            this.resetStamp();
        }
        for (i = 0; i < 3; ++i) {
            this.frozenFirst[i] = this.first[i];
            this.frozenLast[i] = this.last[i] = this.delta.getSize(i);
            this.first[i] = this.last[i];
        }
        this.frozenFirst[3] = this.first[3];
        this.frozenLast[3] = this.last[3] = this.delta.getSize(4);
        this.first[3] = this.last[3];
    }

    public void unfreeze() {
        this.delta.lazyClear();
        this.resetStamp();
        for (int i = 0; i < 3; ++i) {
            this.first[i] = this.last[i] = this.delta.getSize(i);
        }
        this.first[3] = this.last[3] = this.delta.getSize(4);
    }

    public void forEachNode(IntProcedure proc, GraphEventType evt) throws ContradictionException {
        if (evt == GraphEventType.REMOVE_NODE) {
            int type = 0;
            for (int i = this.frozenFirst[type]; i < this.frozenLast[type]; ++i) {
                if (this.delta.getCause(i, type) == this.propagator) continue;
                proc.execute(this.delta.get(i, type));
            }
        } else if (evt == GraphEventType.ADD_NODE) {
            int type = 1;
            for (int i = this.frozenFirst[type]; i < this.frozenLast[type]; ++i) {
                if (this.delta.getCause(i, type) == this.propagator) continue;
                proc.execute(this.delta.get(i, type));
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void forEachArc(PairProcedure proc, GraphEventType evt) throws ContradictionException {
        if (evt == GraphEventType.REMOVE_ARC) {
            for (int i = this.frozenFirst[2]; i < this.frozenLast[2]; ++i) {
                if (this.delta.getCause(i, 2) == this.propagator) continue;
                proc.execute(this.delta.get(i, 2), this.delta.get(i, 3));
            }
        } else if (evt == GraphEventType.ADD_ARC) {
            for (int i = this.frozenFirst[3]; i < this.frozenLast[3]; ++i) {
                if (this.delta.getCause(i, 4) == this.propagator) continue;
                proc.execute(this.delta.get(i, 4), this.delta.get(i, 5));
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }
}

