/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.variables.delta;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.search.loop.TimeStampedObject;
import org.chocosolver.solver.variables.delta.EnumDelta;
import org.chocosolver.solver.variables.delta.IDelta;
import org.chocosolver.solver.variables.delta.IEnumDelta;

public class GraphDelta
extends TimeStampedObject
implements IDelta {
    public static final int NR = 0;
    public static final int NE = 1;
    public static final int AR_tail = 2;
    public static final int AR_head = 3;
    public static final int AE_tail = 4;
    public static final int AE_head = 5;
    public static final int NB = 6;
    private IEnumDelta[] deltaOfType = new IEnumDelta[6];

    public GraphDelta(IEnvironment environment) {
        super(environment);
        for (int i = 0; i < 6; ++i) {
            this.deltaOfType[i] = new EnumDelta(environment);
        }
    }

    public int getSize(int i) {
        return this.deltaOfType[i].size();
    }

    public void add(int element, int type, ICause cause) {
        this.lazyClear();
        this.deltaOfType[type].add(element, cause);
    }

    public void lazyClear() {
        if (this.needReset()) {
            for (int i = 0; i < 6; ++i) {
                this.deltaOfType[i].lazyClear();
            }
            this.resetStamp();
        }
    }

    public int get(int index, int type) {
        return this.deltaOfType[type].get(index);
    }

    public ICause getCause(int index, int type) {
        return this.deltaOfType[type].getCause(index);
    }
}

