/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.variables;

import org.chocosolver.graphsolver.variables.GraphVar;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.util.objects.setDataStructures.ISet;

public interface IncidentSet {
    public ISet getPotSet(GraphVar var1, int var2);

    public ISet getMandSet(GraphVar var1, int var2);

    public boolean enforce(GraphVar var1, int var2, int var3, ICause var4) throws ContradictionException;

    public boolean remove(GraphVar var1, int var2, int var3, ICause var4) throws ContradictionException;

    public static class PredOrNeighSet
    implements IncidentSet {
        @Override
        public ISet getPotSet(GraphVar graph, int i) {
            return graph.getPotPredOrNeighOf(i);
        }

        @Override
        public ISet getMandSet(GraphVar graph, int i) {
            return graph.getMandPredOrNeighOf(i);
        }

        @Override
        public boolean enforce(GraphVar g, int from, int to, ICause cause) throws ContradictionException {
            return g.enforceArc(to, from, cause);
        }

        @Override
        public boolean remove(GraphVar g, int from, int to, ICause cause) throws ContradictionException {
            return g.removeArc(to, from, cause);
        }
    }

    public static class SuccOrNeighSet
    implements IncidentSet {
        @Override
        public ISet getPotSet(GraphVar graph, int i) {
            return graph.getPotSuccOrNeighOf(i);
        }

        @Override
        public ISet getMandSet(GraphVar graph, int i) {
            return graph.getMandSuccOrNeighOf(i);
        }

        @Override
        public boolean enforce(GraphVar g, int from, int to, ICause cause) throws ContradictionException {
            return g.enforceArc(from, to, cause);
        }

        @Override
        public boolean remove(GraphVar g, int from, int to, ICause cause) throws ContradictionException {
            return g.removeArc(from, to, cause);
        }
    }
}

