/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.variables;

import java.util.Arrays;
import org.chocosolver.graphsolver.GraphModel;
import org.chocosolver.graphsolver.variables.DirectedGraphVar;
import org.chocosolver.graphsolver.variables.GraphVar;
import org.chocosolver.graphsolver.variables.UndirectedGraphVar;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.SetType;

public interface IGraphVarFactory {
    public GraphModel _me();

    default public UndirectedGraphVar graphVar(String name, int n) {
        return this.graphVar(name, n, false);
    }

    default public UndirectedGraphVar graphVar(String name, int n, boolean allNodes) {
        UndirectedGraph lb = new UndirectedGraph((Model)this._me(), n, SetType.BITSET, allNodes);
        UndirectedGraph ub = new UndirectedGraph((Model)this._me(), n, SetType.BITSET, allNodes);
        for (int i = 0; i < n; ++i) {
            if (!allNodes) {
                ub.addNode(i);
            }
            for (int j = i; j < n; ++j) {
                ub.addEdge(i, j);
            }
        }
        return this.graphVar(name, lb, ub);
    }

    default public UndirectedGraphVar graphVar(String name, UndirectedGraph lb, UndirectedGraph ub) {
        return new UndirectedGraphVar(name, (Model)this._me(), lb, ub);
    }

    default public DirectedGraphVar digraphVar(String name, int n) {
        return this.digraphVar(name, n, false);
    }

    default public DirectedGraphVar digraphVar(String name, int n, boolean allNodes) {
        DirectedGraph lb = new DirectedGraph((Model)this._me(), n, SetType.BITSET, allNodes);
        DirectedGraph ub = new DirectedGraph((Model)this._me(), n, SetType.BITSET, allNodes);
        for (int i = 0; i < n; ++i) {
            if (!allNodes) {
                ub.addNode(i);
            }
            for (int j = 0; j < n; ++j) {
                ub.addArc(i, j);
            }
        }
        return this.digraphVar(name, lb, ub);
    }

    default public DirectedGraphVar digraphVar(String name, DirectedGraph lb, DirectedGraph ub) {
        return new DirectedGraphVar(name, (Model)this._me(), lb, ub);
    }

    default public GraphVar[] retrieveGraphVars(Model s) {
        int n = s.getNbVars();
        GraphVar[] bvars = new GraphVar[n];
        int k = 0;
        for (int i = 0; i < n; ++i) {
            if ((s.getVar(i).getTypeAndKind() & 0x3F8) != 128) continue;
            bvars[k++] = (GraphVar)s.getVar(i);
        }
        return Arrays.copyOf(bvars, k);
    }

    default public IntVar nbNodes(GraphVar g) {
        IntVar nb = g.getModel().intVar("nbNodes", 0, g.getNbMaxNodes(), true);
        this._me().nbNodes(g, nb).post();
        return nb;
    }

    default public IntVar nbArcs(DirectedGraphVar g) {
        IntVar nb = this._me().intVar("nbArcs", 0, g.getNbMaxNodes() * g.getNbMaxNodes(), true);
        this._me().nbArcs(g, nb).post();
        return nb;
    }

    default public IntVar nbEdges(UndirectedGraphVar g) {
        IntVar nb = this._me().intVar("nbEdges", 0, g.getNbMaxNodes() * g.getNbMaxNodes(), true);
        this._me().nbEdges(g, nb).post();
        return nb;
    }

    default public IntVar nbLoops(GraphVar g) {
        IntVar nb = this._me().intVar("nbLoops", 0, g.getNbMaxNodes(), true);
        this._me().nbLoops(g, nb).post();
        return nb;
    }

    default public SetVar loopSet(GraphVar g) {
        SetVar l = this.makeSetVar("loops", 0, g.getNbMaxNodes());
        this._me().loopSet(g, l).post();
        return l;
    }

    default public SetVar nodeSet(GraphVar g) {
        int n = g.getNbMaxNodes();
        SetVar nodes = this.makeSetVar("nodes", 0, n - 1);
        this._me().nodesChanneling(g, nodes).post();
        return nodes;
    }

    default public BoolVar[] nodeSetBool(GraphVar g) {
        BoolVar[] nodes = this._me().boolVarArray("nodes", g.getNbMaxNodes());
        this._me().nodesChanneling(g, nodes).post();
        return nodes;
    }

    default public BoolVar isNode(GraphVar g, int vertex) {
        BoolVar node = this._me().boolVar("nodes(" + vertex + ")");
        this._me().nodeChanneling(g, node, vertex).post();
        return node;
    }

    default public BoolVar isArc(DirectedGraphVar g, int from, int to) {
        BoolVar node = this._me().boolVar("arc(" + from + "," + to + ")");
        this._me().arcChanneling(g, node, from, to).post();
        return node;
    }

    default public BoolVar isEdge(UndirectedGraphVar g, int v1, int v2) {
        BoolVar node = this._me().boolVar("edge(" + v1 + "," + v2 + ")");
        this._me().edgeChanneling(g, node, v1, v2).post();
        return node;
    }

    default public IntVar[] neighInts(UndirectedGraphVar g) {
        int n = g.getNbMaxNodes();
        IntVar[] successors = this._me().intVarArray("neighOf", n, 0, n - 1, false);
        this._me().neighborsChanneling(g, successors).post();
        return successors;
    }

    default public SetVar[] neighSets(UndirectedGraphVar g) {
        int n = g.getNbMaxNodes();
        SetVar[] neighbors = new SetVar[n];
        for (int i = 0; i < n; ++i) {
            neighbors[i] = this.makeSetVar("neighOf(" + i + ")", 0, n - 1);
        }
        this._me().neighborsChanneling(g, neighbors).post();
        return neighbors;
    }

    default public BoolVar[][] adjacencyMatrix(UndirectedGraphVar g) {
        int n = g.getNbMaxNodes();
        BoolVar[][] neighbors = this._me().boolVarMatrix("neighOf", n, n);
        this._me().neighborsChanneling(g, neighbors).post();
        return neighbors;
    }

    default public SetVar neighSet(UndirectedGraphVar g, int node) {
        int n = g.getNbMaxNodes();
        SetVar neighborsOf = this.makeSetVar("neighOf(" + node + ")", 0, n - 1);
        this._me().neighborsChanneling(g, neighborsOf, node).post();
        return neighborsOf;
    }

    default public BoolVar[] neighBools(UndirectedGraphVar g, int node) {
        BoolVar[] neighborsOf = this._me().boolVarArray("neighOf(" + node + ")", g.getNbMaxNodes());
        this._me().neighborsChanneling(g, neighborsOf, node).post();
        return neighborsOf;
    }

    default public IntVar[] succInts(DirectedGraphVar g) {
        int n = g.getNbMaxNodes();
        IntVar[] successors = this._me().intVarArray("succOf", n, 0, n - 1, false);
        this._me().successorsChanneling(g, successors).post();
        return successors;
    }

    default public SetVar[] succSets(DirectedGraphVar g) {
        int n = g.getNbMaxNodes();
        SetVar[] successors = new SetVar[n];
        for (int i = 0; i < n; ++i) {
            successors[i] = this.makeSetVar("succOf(" + i + ")", 0, n - 1);
        }
        this._me().successorsChanneling(g, successors).post();
        return successors;
    }

    default public BoolVar[][] adjacencyMatrix(DirectedGraphVar g) {
        int n = g.getNbMaxNodes();
        BoolVar[][] successors = this._me().boolVarMatrix("succOf", n, n);
        this._me().successorsChanneling(g, successors).post();
        return successors;
    }

    default public SetVar succSet(DirectedGraphVar g, int node) {
        int n = g.getNbMaxNodes();
        SetVar successorsOf = this.makeSetVar("succOf(" + node + ")", 0, n - 1);
        this._me().successorsChanneling(g, successorsOf, node).post();
        return successorsOf;
    }

    default public BoolVar[] succBools(DirectedGraphVar g, int node) {
        BoolVar[] successorsOf = this._me().boolVarArray("succOf(" + node + ")", g.getNbMaxNodes());
        this._me().successorsChanneling(g, successorsOf, node).post();
        return successorsOf;
    }

    default public SetVar predSet(DirectedGraphVar g, int node) {
        int n = g.getNbMaxNodes();
        SetVar predecessorsOf = this.makeSetVar("predOf(" + node + ")", 0, n - 1);
        this._me().predecessorsChanneling(g, predecessorsOf, node).post();
        return predecessorsOf;
    }

    default public BoolVar[] predBools(DirectedGraphVar g, int node) {
        BoolVar[] predecessorsOf = this._me().boolVarArray("predOf(" + node + ")", g.getNbMaxNodes());
        this._me().predecessorsChanneling(g, predecessorsOf, node).post();
        return predecessorsOf;
    }

    default public IntVar[] degrees(UndirectedGraphVar g) {
        int n = g.getNbMaxNodes();
        IntVar[] degrees = this._me().intVarArray("degree", n, 0, n, true);
        this._me().degrees(g, degrees).post();
        return degrees;
    }

    default public IntVar[] inDegrees(DirectedGraphVar g) {
        int n = g.getNbMaxNodes();
        IntVar[] degrees = this._me().intVarArray("in_degree", n, 0, n, true);
        this._me().inDegrees(g, degrees).post();
        return degrees;
    }

    default public IntVar[] outDegrees(DirectedGraphVar g) {
        int n = g.getNbMaxNodes();
        IntVar[] degrees = this._me().intVarArray("out_degree", n, 0, n, true);
        this._me().outDegrees(g, degrees).post();
        return degrees;
    }

    default public SetVar makeSetVar(String name, int minInt, int maxInt) {
        int[] lb = new int[]{};
        int[] ub = new int[maxInt - minInt + 1];
        for (int i = 0; i < ub.length; ++i) {
            ub[i] = minInt + i;
        }
        return this._me().setVar(name, lb, ub);
    }
}

