/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.variables;

import java.lang.reflect.Field;
import org.chocosolver.graphsolver.variables.GraphEventType;
import org.chocosolver.graphsolver.variables.GraphEvtScheduler;
import org.chocosolver.graphsolver.variables.delta.GraphDelta;
import org.chocosolver.graphsolver.variables.delta.GraphDeltaMonitor;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.impl.AbstractVariable;
import org.chocosolver.util.objects.graphs.IGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public abstract class GraphVar<E extends IGraph>
extends AbstractVariable
implements Variable {
    public static final int GRAPH = 128;
    protected E UB;
    protected E LB;
    protected GraphDelta delta;
    protected int n;
    protected boolean reactOnModification;

    protected GraphVar(String name, Model solver, E LB, E UB) {
        super(name, solver);
        this.LB = LB;
        this.UB = UB;
        this.n = UB.getNbMaxNodes();
        assert (this.n == LB.getNbMaxNodes());
        Field f = null;
        try {
            GraphVar me = this;
            f = ((Object)((Object)me)).getClass().getSuperclass().getSuperclass().getDeclaredField("scheduler");
            f.setAccessible(true);
            f.set((Object)me, new GraphEvtScheduler());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public boolean isInstantiated() {
        if (this.getPotentialNodes().size() != this.getMandatoryNodes().size()) {
            return false;
        }
        ISetIterator iSetIterator = this.getUB().getNodes().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            ISet suc = this.UB.getSuccOrNeighOf(i);
            if (suc.size() == this.getLB().getSuccOrNeighOf(i).size()) continue;
            return false;
        }
        return true;
    }

    public boolean removeNode(int x, ICause cause) throws ContradictionException {
        int i;
        assert (cause != null);
        assert (x >= 0 && x < this.n);
        if (this.LB.getNodes().contains(x)) {
            this.contradiction(cause, "remove mandatory node");
            return true;
        }
        if (!this.UB.getNodes().contains(x)) {
            return false;
        }
        ISet nei = this.UB.getSuccOrNeighOf(x);
        ISetIterator iSetIterator = nei.iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            this.removeArc(x, i, cause);
        }
        nei = this.UB.getPredOrNeighOf(x);
        iSetIterator = nei.iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            this.removeArc(i, x, cause);
        }
        if (this.UB.removeNode(x)) {
            if (this.reactOnModification) {
                this.delta.add(x, 0, cause);
            }
            GraphEventType e = GraphEventType.REMOVE_NODE;
            this.notifyPropagators(e, cause);
            return true;
        }
        return false;
    }

    public boolean enforceNode(int x, ICause cause) throws ContradictionException {
        assert (cause != null);
        assert (x >= 0 && x < this.n);
        if (this.UB.getNodes().contains(x)) {
            if (this.LB.addNode(x)) {
                if (this.reactOnModification) {
                    this.delta.add(x, 1, cause);
                }
                GraphEventType e = GraphEventType.ADD_NODE;
                this.notifyPropagators(e, cause);
                return true;
            }
            return false;
        }
        this.contradiction(cause, "enforce node which is not in the domain");
        return true;
    }

    public abstract boolean removeArc(int var1, int var2, ICause var3) throws ContradictionException;

    public abstract boolean enforceArc(int var1, int var2, ICause var3) throws ContradictionException;

    public E getLB() {
        return this.LB;
    }

    public E getUB() {
        return this.UB;
    }

    public ISet getMandSuccOrNeighOf(int idx) {
        return this.LB.getSuccOrNeighOf(idx);
    }

    public ISet getPotSuccOrNeighOf(int idx) {
        return this.UB.getSuccOrNeighOf(idx);
    }

    public ISet getMandPredOrNeighOf(int idx) {
        return this.LB.getPredOrNeighOf(idx);
    }

    public ISet getPotPredOrNeighOf(int idx) {
        return this.UB.getPredOrNeighOf(idx);
    }

    public int getNbMaxNodes() {
        return this.n;
    }

    public ISet getMandatoryNodes() {
        return this.LB.getNodes();
    }

    public ISet getPotentialNodes() {
        return this.UB.getNodes();
    }

    public abstract boolean isDirected();

    public GraphDelta getDelta() {
        return this.delta;
    }

    public int getTypeAndKind() {
        return 129;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("graph_var ").append(this.getName());
        if (this.isInstantiated()) {
            sb.append("\nValue: \n");
            sb.append(this.UB.toString());
        } else {
            sb.append("\nUpper bound: \n");
            sb.append(this.UB.toString());
            sb.append("\nLower bound: \n");
            sb.append(this.LB.toString());
        }
        return sb.toString();
    }

    public void createDelta() {
        if (!this.reactOnModification) {
            this.reactOnModification = true;
            this.delta = new GraphDelta(this.getEnvironment());
        }
    }

    public GraphDeltaMonitor monitorDelta(ICause propagator) {
        this.createDelta();
        return new GraphDeltaMonitor(this.delta, propagator);
    }

    public void notifyMonitors(IEventType event) throws ContradictionException {
        for (int i = this.mIdx - 1; i >= 0; --i) {
            this.monitors[i].onUpdate((Variable)this, event);
        }
    }

    public boolean[][] getValue() {
        int n = this.getUB().getNbMaxNodes();
        boolean[][] vals = new boolean[n + 1][n];
        ISetIterator iSetIterator = this.getLB().getNodes().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            ISetIterator iSetIterator2 = this.getLB().getSuccOrNeighOf(i).iterator();
            while (iSetIterator2.hasNext()) {
                int j = (Integer)iSetIterator2.next();
                vals[i][j] = true;
            }
            vals[n][i] = true;
        }
        return vals;
    }

    public void instantiateTo(boolean[][] value, ICause cause) throws ContradictionException {
        int n = value.length - 1;
        for (int i = 0; i < n; ++i) {
            if (value[n][i]) {
                this.enforceNode(i, cause);
            } else {
                this.removeNode(i, cause);
            }
            for (int j = 0; j < n; ++j) {
                if (value[i][j]) {
                    this.enforceArc(i, j, cause);
                    continue;
                }
                this.removeArc(i, j, cause);
            }
        }
    }

    public String graphVizExport() {
        int j;
        ISetIterator iSetIterator;
        int i;
        boolean directed = this.isDirected();
        String arc = directed ? " -> " : " -- ";
        StringBuilder sb = new StringBuilder();
        sb.append(directed ? "digraph " : "graph ").append(this.getName() + "{\n");
        sb.append("node [color = red, fontcolor=red]; ");
        ISetIterator iSetIterator2 = this.getMandatoryNodes().iterator();
        while (iSetIterator2.hasNext()) {
            i = (Integer)iSetIterator2.next();
            sb.append(i + " ");
        }
        sb.append(";\n");
        iSetIterator2 = this.getMandatoryNodes().iterator();
        while (iSetIterator2.hasNext()) {
            i = (Integer)iSetIterator2.next();
            iSetIterator = this.getMandSuccOrNeighOf(i).iterator();
            while (iSetIterator.hasNext()) {
                j = (Integer)iSetIterator.next();
                if (!directed && i >= j) continue;
                sb.append(i + arc + j + " [color=red] ;\n");
            }
        }
        if (this.getMandatoryNodes().size() < this.getPotentialNodes().size()) {
            sb.append("node [color = black, fontcolor=black]; ");
            iSetIterator2 = this.getPotentialNodes().iterator();
            while (iSetIterator2.hasNext()) {
                i = (Integer)iSetIterator2.next();
                if (this.getMandatoryNodes().contains(i)) continue;
                sb.append(i + " ");
            }
            sb.append(";\n");
        }
        iSetIterator2 = this.getPotentialNodes().iterator();
        while (iSetIterator2.hasNext()) {
            i = (Integer)iSetIterator2.next();
            iSetIterator = this.getPotSuccOrNeighOf(i).iterator();
            while (iSetIterator.hasNext()) {
                j = (Integer)iSetIterator.next();
                if (!directed && i >= j || this.getMandSuccOrNeighOf(i).contains(j)) continue;
                sb.append(i + arc + j + " ;\n");
            }
        }
        sb.append("}");
        return sb.toString();
    }
}

