/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.variables;

import org.chocosolver.graphsolver.variables.GraphEventType;
import org.chocosolver.graphsolver.variables.GraphVar;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;

public class DirectedGraphVar
extends GraphVar<DirectedGraph> {
    public DirectedGraphVar(String name, Model solver, DirectedGraph LB, DirectedGraph UB) {
        super(name, solver, LB, UB);
    }

    @Override
    public boolean removeArc(int x, int y, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (((DirectedGraph)this.LB).arcExists(x, y)) {
            this.contradiction(cause, "remove mandatory arc " + x + "->" + y);
            return false;
        }
        if (((DirectedGraph)this.UB).removeArc(x, y)) {
            if (this.reactOnModification) {
                this.delta.add(x, 2, cause);
                this.delta.add(y, 3, cause);
            }
            GraphEventType e = GraphEventType.REMOVE_ARC;
            this.notifyPropagators(e, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean enforceArc(int x, int y, ICause cause) throws ContradictionException {
        assert (cause != null);
        this.enforceNode(x, cause);
        this.enforceNode(y, cause);
        if (((DirectedGraph)this.UB).arcExists(x, y)) {
            if (((DirectedGraph)this.LB).addArc(x, y)) {
                if (this.reactOnModification) {
                    this.delta.add(x, 4, cause);
                    this.delta.add(y, 5, cause);
                }
                GraphEventType e = GraphEventType.ADD_ARC;
                this.notifyPropagators(e, cause);
                return true;
            }
            return false;
        }
        this.contradiction(cause, "enforce arc which is not in the domain");
        return false;
    }

    public ISet getMandSuccOf(int idx) {
        return this.getMandSuccOrNeighOf(idx);
    }

    public ISet getMandPredOf(int idx) {
        return this.getMandPredOrNeighOf(idx);
    }

    public ISet getPotPredOf(int idx) {
        return this.getPotPredOrNeighOf(idx);
    }

    public ISet getPotSuccOf(int idx) {
        return this.getPotSuccOrNeighOf(idx);
    }

    @Override
    public boolean isDirected() {
        return true;
    }
}

