/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.util;

import java.util.Iterator;
import org.chocosolver.graphsolver.util.BitOperations;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class LCAGraphManager {
    private int root;
    private DirectedGraph graph;
    private int nbNodes;
    private int nbActives;
    private int[] father;
    private int[] nodeOfDfsNumber;
    private int[] dfsNumberOfNode;
    private int[] I;
    private int[] L;
    private int[] h;
    private int[] A;
    private int[] htmp;
    private ISet[] successors;
    private Iterator<Integer>[] iterator;

    public LCAGraphManager(int nb) {
        this.nbNodes = nb;
        this.successors = new ISet[this.nbNodes];
        this.father = new int[this.nbNodes];
        this.nodeOfDfsNumber = new int[this.nbNodes];
        this.dfsNumberOfNode = new int[this.nbNodes];
        this.htmp = new int[this.nbNodes];
        this.A = new int[this.nbNodes];
        this.I = new int[this.nbNodes];
        this.L = new int[this.nbNodes];
        this.h = new int[this.nbNodes];
        this.iterator = new Iterator[this.nbNodes];
    }

    public void preprocess(int r, DirectedGraph g) {
        this.root = r;
        this.graph = g;
        this.initParams();
        this.proceedFirstDFS();
        this.performLCAPreprocessing();
    }

    public int getLCA(int x, int y) {
        return this.nodeOfDfsNumber[this.getDFS_LCA(this.dfsNumberOfNode[x], this.dfsNumberOfNode[y])];
    }

    private void initParams() {
        this.nbActives = this.graph.getNodes().size();
        for (int i = 0; i < this.nbNodes; ++i) {
            this.successors[i] = this.graph.getSuccOf(i);
            this.dfsNumberOfNode[i] = -1;
            this.father[i] = -1;
            this.A[i] = -1;
        }
    }

    private void proceedFirstDFS() {
        int k;
        int i;
        for (i = 0; i < this.nbNodes; ++i) {
            this.iterator[i] = this.successors[i].iterator();
        }
        i = this.root;
        this.father[k] = k = 0;
        this.dfsNumberOfNode[this.root] = k;
        this.nodeOfDfsNumber[k] = this.root;
        ++k;
        while (true) {
            if (this.iterator[i].hasNext()) {
                int j = this.iterator[i].next();
                if (this.dfsNumberOfNode[j] != -1) continue;
                this.father[k] = this.dfsNumberOfNode[i];
                this.dfsNumberOfNode[j] = k;
                this.nodeOfDfsNumber[k] = j;
                i = j;
                ++k;
                continue;
            }
            if (i == this.root) break;
            i = this.nodeOfDfsNumber[this.father[this.dfsNumberOfNode[i]]];
        }
        if (k != this.nbActives) {
            throw new UnsupportedOperationException("LCApreprocess did not reach all nodes");
        }
        while (k < this.nbNodes) {
            this.father[k] = -1;
            ++k;
        }
    }

    private void performLCAPreprocessing() {
        for (int i = this.nbActives - 1; i >= 0; --i) {
            this.h[i] = BitOperations.getFirstExp(i + 1);
            if (this.h[i] == -1) {
                throw new UnsupportedOperationException();
            }
            this.htmp[i] = this.h[i];
            this.I[i] = i;
            this.L[i] = i;
            int sucInRun = -1;
            ISet nei = this.graph.getSuccOf(this.nodeOfDfsNumber[i]);
            ISetIterator iSetIterator = nei.iterator();
            while (iSetIterator.hasNext()) {
                int k = (Integer)iSetIterator.next();
                int s = this.dfsNumberOfNode[k];
                if (i == s || this.father[s] != i || this.htmp[s] <= this.htmp[i]) continue;
                this.htmp[i] = this.htmp[s];
                sucInRun = s;
            }
            if (sucInRun == -1) continue;
            this.I[i] = this.I[sucInRun];
            this.L[this.I[i]] = i;
        }
        int exp = BitOperations.getFirstExp(this.I[0] + 1);
        if (exp == -1) {
            throw new UnsupportedOperationException();
        }
        this.A[0] = BitOperations.pow(2, exp);
        for (int i = 0; i < this.nbActives; ++i) {
            this.A[i] = this.A[this.father[i]];
            if (this.I[i] == this.I[this.father[i]]) continue;
            exp = BitOperations.getFirstExp(this.I[i] + 1);
            if (exp == -1) {
                throw new UnsupportedOperationException();
            }
            int n = i;
            this.A[n] = this.A[n] + BitOperations.pow(2, exp);
        }
    }

    private int getDFS_LCA(int x, int y) {
        int yPrim;
        if (x == y || x == this.father[y]) {
            return x;
        }
        if (y == this.father[x]) {
            return y;
        }
        int b = BitOperations.binaryLCA(this.I[x] + 1, this.I[y] + 1);
        int hb = BitOperations.getFirstExp(b);
        if (hb == -1) {
            throw new UnsupportedOperationException();
        }
        int j = BitOperations.getFirstExpInBothXYfromI(this.A[x], this.A[y], hb);
        if (j == -1) {
            throw new UnsupportedOperationException();
        }
        int xPrim = this.closestFrom(x, j);
        if (xPrim < (yPrim = this.closestFrom(y, j))) {
            return xPrim;
        }
        return yPrim;
    }

    private int closestFrom(int x, int j) {
        int l = BitOperations.getFirstExp(this.A[x]);
        if (l == -1) {
            throw new UnsupportedOperationException();
        }
        if (l == j) {
            return x;
        }
        int k = BitOperations.getMaxExpBefore(this.A[x], j);
        int IW = this.I[x] + 1;
        if (k == -1) {
            throw new UnsupportedOperationException();
        }
        IW = BitOperations.replaceBy1and0sFrom(IW, k);
        return this.father[this.L[--IW]];
    }

    public int getParentOf(int x) {
        return this.nodeOfDfsNumber[this.father[this.dfsNumberOfNode[x]]];
    }

    public int[] getNodeOfDfsNumber() {
        return this.nodeOfDfsNumber;
    }

    public int[] getDfsNumberOfNode() {
        return this.dfsNumberOfNode;
    }
}

