/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.util;

import gnu.trove.list.array.TIntArrayList;
import java.util.Iterator;
import org.chocosolver.util.objects.graphs.IGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class ConnectivityFinder {
    private int n;
    private IGraph graph;
    private int[] CC_firstNode;
    private int[] CC_nextNode;
    private int[] node_CC;
    private int[] p;
    private int[] fifo;
    private int nbCC;
    private int[] numOfNode;
    private int[] nodeOfNum;
    private int[] inf;
    private Iterator<Integer>[] iterators;
    public TIntArrayList isthmusFrom;
    public TIntArrayList isthmusTo;
    private int[] ND;
    private int[] L;
    private int[] H;

    public ConnectivityFinder(IGraph g) {
        this.graph = g;
        this.n = g.getNbMaxNodes();
        this.p = new int[this.n];
        this.fifo = new int[this.n];
        this.iterators = new Iterator[this.n];
    }

    public int getNBCC() {
        return this.nbCC;
    }

    public int[] getCC_firstNode() {
        return this.CC_firstNode;
    }

    public int[] getCC_nextNode() {
        return this.CC_nextNode;
    }

    public int[] getNode_CC() {
        return this.node_CC;
    }

    public void findAllCC() {
        if (this.node_CC == null) {
            this.CC_firstNode = new int[this.n];
            this.CC_nextNode = new int[this.n];
            this.node_CC = new int[this.n];
        }
        ISet act = this.graph.getNodes();
        ISetIterator iSetIterator = act.iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            this.p[i] = -1;
        }
        for (int i = 0; i < this.CC_firstNode.length; ++i) {
            this.CC_firstNode[i] = -1;
        }
        int cc = 0;
        ISetIterator iSetIterator2 = act.iterator();
        while (iSetIterator2.hasNext()) {
            int i = (Integer)iSetIterator2.next();
            if (this.p[i] != -1) continue;
            this.findCC(i, cc);
            ++cc;
        }
        this.nbCC = cc;
    }

    private void findCC(int start, int cc) {
        int first = 0;
        int last = 0;
        this.fifo[last++] = start;
        this.p[start] = start;
        this.add(start, cc);
        while (first < last) {
            int j;
            int i = this.fifo[first++];
            ISetIterator iSetIterator = this.graph.getSuccOrNeighOf(i).iterator();
            while (iSetIterator.hasNext()) {
                j = (Integer)iSetIterator.next();
                if (this.p[j] != -1) continue;
                this.p[j] = i;
                this.add(j, cc);
                this.fifo[last++] = j;
            }
            if (!this.graph.isDirected()) continue;
            iSetIterator = this.graph.getPredOrNeighOf(i).iterator();
            while (iSetIterator.hasNext()) {
                j = (Integer)iSetIterator.next();
                if (this.p[j] != -1) continue;
                this.p[j] = i;
                this.add(j, cc);
                this.fifo[last++] = j;
            }
        }
    }

    private void add(int node, int cc) {
        this.node_CC[node] = cc;
        this.CC_nextNode[node] = this.CC_firstNode[cc];
        this.CC_firstNode[cc] = node;
    }

    public boolean isBiconnected() {
        int k;
        int start;
        int i;
        assert (!this.graph.isDirected());
        if (this.nodeOfNum == null) {
            this.nodeOfNum = new int[this.n];
            this.numOfNode = new int[this.n];
            this.inf = new int[this.n];
        }
        ISet act = this.graph.getNodes();
        ISetIterator iSetIterator = act.iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            this.inf[i] = Integer.MAX_VALUE;
            this.p[i] = -1;
            this.iterators[i] = this.graph.getSuccOrNeighOf(i).iterator();
        }
        i = start = act.iterator().next().intValue();
        this.numOfNode[start] = k = 0;
        this.nodeOfNum[k] = start;
        this.p[start] = start;
        int nbRootChildren = 0;
        while (true) {
            if (this.iterators[i].hasNext()) {
                int j = this.iterators[i].next();
                if (this.p[j] == -1) {
                    this.p[j] = i;
                    if (i == start && ++nbRootChildren > 1) {
                        return false;
                    }
                    i = j;
                    this.numOfNode[i] = ++k;
                    this.nodeOfNum[k] = i;
                    this.inf[i] = this.numOfNode[i];
                    continue;
                }
                if (this.p[i] == j) continue;
                this.inf[i] = Math.min(this.inf[i], this.numOfNode[j]);
                continue;
            }
            if (i == start) {
                return k >= act.size() - 1;
            }
            int q = this.inf[i];
            i = this.p[i];
            this.inf[i] = Math.min(q, this.inf[i]);
            if (q >= this.numOfNode[i] && i != start) break;
        }
        return false;
    }

    public boolean isConnectedAndFindIsthma() {
        int k;
        int start;
        int i;
        assert (!this.graph.isDirected());
        if (this.numOfNode == null || this.CC_firstNode == null) {
            this.CC_firstNode = new int[this.n];
            this.CC_nextNode = new int[this.n];
            this.node_CC = new int[this.n];
            this.nodeOfNum = new int[this.n];
            this.numOfNode = new int[this.n];
            this.isthmusFrom = new TIntArrayList();
            this.isthmusTo = new TIntArrayList();
            this.ND = new int[this.n];
            this.L = new int[this.n];
            this.H = new int[this.n];
        }
        ISet act = this.graph.getNodes();
        ISetIterator iSetIterator = act.iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            this.p[i] = -1;
            this.iterators[i] = this.graph.getSuccOrNeighOf(i).iterator();
        }
        for (int i2 = 0; i2 < this.CC_firstNode.length; ++i2) {
            this.CC_firstNode[i2] = -1;
        }
        i = start = act.iterator().next().intValue();
        this.numOfNode[start] = k = 0;
        this.nodeOfNum[k] = start;
        this.p[start] = start;
        while (true) {
            if (this.iterators[i].hasNext()) {
                int j = this.iterators[i].next();
                if (this.p[j] != -1) continue;
                this.p[j] = i;
                i = j;
                this.add(i, 0);
                this.numOfNode[i] = ++k;
                this.nodeOfNum[k] = i;
                continue;
            }
            if (i == start) {
                if (k >= act.size() - 1) break;
                return false;
            }
            i = this.p[i];
        }
        this.isthmusFrom.clear();
        this.isthmusTo.clear();
        for (i = k; i >= 0; --i) {
            int currentNode = this.nodeOfNum[i];
            this.ND[currentNode] = 1;
            this.L[currentNode] = i;
            this.H[currentNode] = i;
            ISetIterator iSetIterator2 = this.graph.getSuccOrNeighOf(currentNode).iterator();
            while (iSetIterator2.hasNext()) {
                int s = (Integer)iSetIterator2.next();
                if (this.p[s] == currentNode) {
                    int n = currentNode;
                    this.ND[n] = this.ND[n] + this.ND[s];
                    this.L[currentNode] = Math.min(this.L[currentNode], this.L[s]);
                    this.H[currentNode] = Math.max(this.H[currentNode], this.H[s]);
                } else if (s != this.p[currentNode]) {
                    this.L[currentNode] = Math.min(this.L[currentNode], this.numOfNode[s]);
                    this.H[currentNode] = Math.max(this.H[currentNode], this.numOfNode[s]);
                }
                if (s == currentNode || this.p[s] != currentNode || this.L[s] < this.numOfNode[s] || this.H[s] >= this.numOfNode[s] + this.ND[s]) continue;
                this.isthmusFrom.add(currentNode);
                this.isthmusTo.add(s);
            }
        }
        return true;
    }
}

