/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.util;

public class BitOperations {
    public static int binaryLCA(int x, int y) {
        if (x == y) {
            return x;
        }
        int xor = x ^ y;
        int idx = BitOperations.getMaxExp(xor);
        if (idx == -1) {
            throw new UnsupportedOperationException();
        }
        return BitOperations.replaceBy1and0sFrom(x, idx);
    }

    public static int replaceBy1and0sFrom(int x, int idx) {
        x >>>= idx + 1;
        x <<= 1;
        ++x;
        return x <<= idx;
    }

    public static int getMaxExp(int x) {
        int exp = -1;
        while (x > 0) {
            ++exp;
            x /= 2;
        }
        return exp;
    }

    public static int getMaxExpBefore(int x, int j) {
        return BitOperations.getMaxExp(x %= BitOperations.pow(2, j));
    }

    public static int getFirstExp(int x) {
        if (x == 0) {
            return -1;
        }
        int exp = 0;
        while (x % 2 == 0) {
            ++exp;
            x /= 2;
        }
        return exp;
    }

    public static int getFirstExpInBothXYfromI(int x, int y, int i) {
        if (((x >>>= i) & (y >>>= i)) == 0) {
            return -1;
        }
        while (x % 2 == 0 || y % 2 == 0) {
            ++i;
            x /= 2;
            y /= 2;
        }
        return i;
    }

    public static int pow(int x, int pow) {
        if (pow < 0) {
            throw new UnsupportedOperationException();
        }
        if (pow == 0) {
            return 1;
        }
        --pow;
        int xp = x;
        while (pow > 0) {
            --pow;
            xp *= x;
        }
        return xp;
    }
}

