/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.search.strategy.arcs;

import gnu.trove.list.array.TIntArrayList;
import java.util.Random;
import org.chocosolver.graphsolver.search.strategy.ArcStrategy;
import org.chocosolver.graphsolver.variables.GraphVar;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class RandomArc
extends ArcStrategy<GraphVar> {
    private Random rd;
    private TIntArrayList pFrom;
    private TIntArrayList pTo;

    public RandomArc(GraphVar g, long seed) {
        super(g);
        this.rd = new Random(seed);
        this.pFrom = new TIntArrayList();
        this.pTo = new TIntArrayList();
    }

    @Override
    public boolean computeNextArc() {
        this.pFrom.clear();
        this.pTo.clear();
        ISetIterator iSetIterator = this.envNodes.iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            ISet envSuc = this.g.getPotSuccOrNeighOf(i);
            ISet kerSuc = this.g.getMandSuccOrNeighOf(i);
            if (envSuc.size() == kerSuc.size()) continue;
            ISetIterator iSetIterator2 = envSuc.iterator();
            while (iSetIterator2.hasNext()) {
                int j = (Integer)iSetIterator2.next();
                if (kerSuc.contains(j)) continue;
                this.pFrom.add(i);
                this.pTo.add(j);
            }
        }
        if (this.pFrom.isEmpty()) {
            this.to = -1;
            this.from = -1;
            return false;
        }
        int idx = this.rd.nextInt(this.pFrom.size());
        this.from = this.pFrom.get(idx);
        this.to = this.pTo.get(idx);
        return true;
    }
}

