/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.search.strategy;

import org.chocosolver.graphsolver.search.GraphAssignment;
import org.chocosolver.graphsolver.search.GraphDecision;
import org.chocosolver.graphsolver.search.strategy.ArcStrategy;
import org.chocosolver.graphsolver.search.strategy.NodeStrategy;
import org.chocosolver.graphsolver.search.strategy.arcs.LexArc;
import org.chocosolver.graphsolver.search.strategy.arcs.RandomArc;
import org.chocosolver.graphsolver.search.strategy.nodes.LexNode;
import org.chocosolver.graphsolver.search.strategy.nodes.RandomNode;
import org.chocosolver.graphsolver.variables.GraphVar;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.PoolManager;

public class GraphStrategy
extends AbstractStrategy<GraphVar> {
    protected GraphVar g;
    protected NodeStrategy nodeStrategy;
    protected ArcStrategy arcStrategy;
    protected NodeArcPriority priority;
    protected PoolManager<GraphDecision> pool;

    public GraphStrategy(GraphVar g, NodeStrategy ns, ArcStrategy as, NodeArcPriority priority) {
        super((Variable[])new GraphVar[]{g});
        this.g = g;
        this.nodeStrategy = ns;
        this.arcStrategy = as;
        this.priority = priority;
        this.pool = new PoolManager();
    }

    public GraphStrategy(GraphVar g) {
        this(g, new LexNode(g), new LexArc(g), NodeArcPriority.NODES_THEN_ARCS);
    }

    public GraphStrategy(GraphVar g, long seed) {
        this(g, new RandomNode(g, seed), new RandomArc(g, seed), NodeArcPriority.NODES_THEN_ARCS);
    }

    public boolean init() {
        return true;
    }

    public GraphDecision getDecision() {
        if (this.g.isInstantiated()) {
            return null;
        }
        GraphDecision dec = (GraphDecision)((Object)this.pool.getE());
        if (dec == null) {
            dec = new GraphDecision(this.pool);
        }
        switch (this.priority) {
            case NODES_THEN_ARCS: {
                int node = this.nextNode();
                if (node != -1) {
                    dec.setNode(this.g, node, GraphAssignment.graph_enforcer);
                    break;
                }
                if (this.arcStrategy == null) {
                    return null;
                }
                this.nextArc();
                dec.setArc(this.g, this.arcStrategy.getFrom(), this.arcStrategy.getTo(), GraphAssignment.graph_enforcer);
                break;
            }
            default: {
                if (!this.nextArc()) {
                    return null;
                }
                dec.setArc(this.g, this.arcStrategy.getFrom(), this.arcStrategy.getTo(), GraphAssignment.graph_enforcer);
            }
        }
        return dec;
    }

    public int nextNode() {
        return this.nodeStrategy.nextNode();
    }

    public boolean nextArc() {
        return this.arcStrategy.computeNextArc();
    }

    public static enum NodeArcPriority {
        NODES_THEN_ARCS,
        ARCS;

    }
}

