/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.search.strategy;

import org.chocosolver.graphsolver.search.GraphAssignment;
import org.chocosolver.graphsolver.search.GraphDecision;
import org.chocosolver.graphsolver.search.strategy.GraphStrategy;
import org.chocosolver.graphsolver.variables.GraphVar;
import org.chocosolver.util.PoolManager;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class GraphSearch
extends GraphStrategy {
    public static final int LEX = 0;
    public static final int MIN_P_DEGREE = 1;
    public static final int MAX_P_DEGREE = 2;
    public static final int MIN_M_DEGREE = 3;
    public static final int MAX_M_DEGREE = 4;
    public static final int MIN_DELTA_DEGREE = 5;
    public static final int MAX_DELTA_DEGREE = 6;
    public static final int MIN_COST = 7;
    public static final int MAX_COST = 8;
    private int n;
    private int mode;
    private int[][] costs;
    private GraphAssignment decisionType;
    private int from;
    private int to;
    private int value;
    private boolean useLC;
    private int lastFrom = -1;

    public GraphSearch(GraphVar graphVar) {
        this(graphVar, null);
    }

    public GraphSearch(GraphVar graphVar, int[][] costMatrix) {
        super(graphVar, null, null, GraphStrategy.NodeArcPriority.ARCS);
        this.costs = costMatrix;
        this.n = this.g.getNbMaxNodes();
    }

    public GraphSearch configure(int policy) {
        return this.configure(policy, true);
    }

    public GraphSearch configure(int policy, boolean enforce) {
        this.decisionType = enforce ? GraphAssignment.graph_enforcer : GraphAssignment.graph_remover;
        this.mode = policy;
        return this;
    }

    public GraphSearch useLastConflict() {
        this.useLC = true;
        return this;
    }

    @Override
    public GraphDecision getDecision() {
        if (this.g.isInstantiated()) {
            return null;
        }
        GraphDecision dec = (GraphDecision)((Object)this.pool.getE());
        if (dec == null) {
            dec = new GraphDecision((PoolManager<GraphDecision>)this.pool);
        }
        this.computeNextArc();
        dec.setArc(this.g, this.from, this.to, this.decisionType);
        this.lastFrom = this.from;
        return dec;
    }

    private void computeNextArc() {
        this.to = -1;
        this.from = -1;
        if (this.useLC && this.lastFrom != -1) {
            this.evaluateNeighbors(this.lastFrom);
            if (this.to != -1) {
                return;
            }
        }
        for (int i = 0; i < this.n; ++i) {
            if (!this.evaluateNeighbors(i)) continue;
            return;
        }
        if (this.to == -1) {
            throw new UnsupportedOperationException();
        }
    }

    private boolean evaluateNeighbors(int i) {
        ISet set = this.g.getPotSuccOrNeighOf(i);
        if (set.size() == this.g.getMandSuccOrNeighOf(i).size()) {
            return false;
        }
        ISetIterator iSetIterator = set.iterator();
        while (iSetIterator.hasNext()) {
            int j = (Integer)iSetIterator.next();
            if (this.g.getMandSuccOrNeighOf(i).contains(j)) continue;
            int v = -1;
            switch (this.mode) {
                case 0: {
                    this.from = i;
                    this.to = j;
                    return true;
                }
                case 1: 
                case 2: {
                    v = this.g.getPotSuccOrNeighOf(i).size() + this.g.getPotPredOrNeighOf(j).size();
                    break;
                }
                case 3: 
                case 4: {
                    v = this.g.getMandSuccOrNeighOf(i).size() + this.g.getMandPredOrNeighOf(j).size();
                    break;
                }
                case 5: 
                case 6: {
                    v = this.g.getPotSuccOrNeighOf(i).size() + this.g.getPotPredOrNeighOf(j).size() - this.g.getMandSuccOrNeighOf(i).size() - this.g.getMandPredOrNeighOf(j).size();
                    break;
                }
                case 7: 
                case 8: {
                    v = this.costs[i][j];
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("mode " + this.mode + " does not exist");
                }
            }
            if (!this.select(v)) continue;
            this.value = v;
            this.from = i;
            this.to = j;
        }
        return false;
    }

    private boolean select(double v) {
        return this.from == -1 || v < (double)this.value && GraphSearch.isMinOrIn(this.mode) || v > (double)this.value && !GraphSearch.isMinOrIn(this.mode);
    }

    private static boolean isMinOrIn(int policy) {
        return policy % 2 == 1;
    }
}

