/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.search;

import org.chocosolver.graphsolver.search.GraphAssignment;
import org.chocosolver.graphsolver.variables.GraphVar;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.PoolManager;

public class GraphDecision
extends Decision<GraphVar> {
    protected GraphAssignment assignment;
    protected int from;
    protected int to;
    protected final PoolManager<GraphDecision> poolManager;

    public GraphDecision(PoolManager<GraphDecision> poolManager) {
        super(2);
        this.poolManager = poolManager;
    }

    public Object getDecisionValue() {
        if (this.to == -1) {
            return this.from;
        }
        return new int[]{this.from, this.to};
    }

    public void setNode(GraphVar variable, int node, GraphAssignment graph_ass) {
        super.set((Variable)variable);
        this.from = node;
        this.to = -1;
        this.assignment = graph_ass;
    }

    public void setArc(GraphVar variable, int from, int to, GraphAssignment graph_ass) {
        super.set((Variable)variable);
        this.from = from;
        this.to = to;
        this.assignment = graph_ass;
    }

    public void apply() throws ContradictionException {
        if (this.branch == 1) {
            if (this.to == -1) {
                this.assignment.apply((GraphVar)this.var, this.from, (ICause)this);
            } else {
                this.assignment.apply((GraphVar)this.var, this.from, this.to, (ICause)this);
            }
        } else if (this.branch == 2) {
            if (this.to == -1) {
                this.assignment.unapply((GraphVar)this.var, this.from, (ICause)this);
            } else {
                this.assignment.unapply((GraphVar)this.var, this.from, this.to, (ICause)this);
            }
        }
    }

    public void free() {
        this.poolManager.returnE((Object)this);
    }

    public String toString() {
        if (this.to == -1) {
            return " node " + this.from + this.assignment.toString();
        }
        return " arc (" + this.from + "," + this.to + ")" + this.assignment.toString();
    }
}

