/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.search;

import java.io.Serializable;
import org.chocosolver.graphsolver.variables.GraphVar;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;

public abstract class GraphAssignment
implements Serializable {
    public static GraphAssignment graph_enforcer = new GraphAssignment(){

        @Override
        public void apply(GraphVar var, int node, ICause cause) throws ContradictionException {
            if (node >= var.getNbMaxNodes()) {
                throw new UnsupportedOperationException();
            }
            var.enforceNode(node, cause);
        }

        @Override
        public void unapply(GraphVar var, int node, ICause cause) throws ContradictionException {
            if (node >= var.getNbMaxNodes()) {
                throw new UnsupportedOperationException();
            }
            var.removeNode(node, cause);
        }

        @Override
        public void apply(GraphVar var, int from, int to, ICause cause) throws ContradictionException {
            if (from == -1 || to == -1) {
                throw new UnsupportedOperationException();
            }
            var.enforceArc(from, to, cause);
        }

        @Override
        public void unapply(GraphVar var, int from, int to, ICause cause) throws ContradictionException {
            if (from == -1 || to == -1) {
                throw new UnsupportedOperationException();
            }
            var.removeArc(from, to, cause);
        }

        @Override
        public String toString() {
            return " enforcing ";
        }
    };
    public static GraphAssignment graph_remover = new GraphAssignment(){

        @Override
        public void apply(GraphVar var, int value, ICause cause) throws ContradictionException {
            graph_enforcer.unapply(var, value, cause);
        }

        @Override
        public void unapply(GraphVar var, int value, ICause cause) throws ContradictionException {
            graph_enforcer.apply(var, value, cause);
        }

        @Override
        public void apply(GraphVar var, int from, int to, ICause cause) throws ContradictionException {
            graph_enforcer.unapply(var, from, to, cause);
        }

        @Override
        public void unapply(GraphVar var, int from, int to, ICause cause) throws ContradictionException {
            graph_enforcer.apply(var, from, to, cause);
        }

        @Override
        public String toString() {
            return " removal ";
        }
    };

    public abstract void apply(GraphVar var1, int var2, ICause var3) throws ContradictionException;

    public abstract void unapply(GraphVar var1, int var2, ICause var3) throws ContradictionException;

    public abstract void apply(GraphVar var1, int var2, int var3, ICause var4) throws ContradictionException;

    public abstract void unapply(GraphVar var1, int var2, int var3, ICause var4) throws ContradictionException;

    public abstract String toString();
}

