/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.tree;

import java.util.BitSet;
import org.chocosolver.graphsolver.cstrs.tree.PropArborescences;
import org.chocosolver.graphsolver.variables.DirectedGraphVar;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropArborescence
extends PropArborescences {
    protected final int root;
    protected final BitSet visited;
    protected final int[] fifo;

    public PropArborescence(DirectedGraphVar graph, int root) {
        this(graph, root, false);
    }

    public PropArborescence(DirectedGraphVar graph, int root, boolean simple) {
        super(graph, simple);
        this.root = root;
        this.visited = new BitSet(this.n);
        this.fifo = new int[this.n];
    }

    @Override
    public void propagate(int evt) throws ContradictionException {
        this.g.enforceNode(this.root, (ICause)this);
        this.explore();
        int o = this.visited.nextClearBit(0);
        while (o < this.n) {
            this.g.removeNode(o, (ICause)this);
            o = this.visited.nextClearBit(o + 1);
        }
        super.propagate(evt);
    }

    @Override
    protected void reset() {
        int i;
        for (i = 0; i < this.n + 1; ++i) {
            this.connectedGraph.getSuccOf(i).clear();
            this.connectedGraph.getPredOf(i).clear();
        }
        for (i = 0; i < this.n; ++i) {
            ISetIterator iSetIterator = this.g.getPotPredOf(i).iterator();
            while (iSetIterator.hasNext()) {
                int y = (Integer)iSetIterator.next();
                this.connectedGraph.addArc(y, i);
            }
            if (this.g.getPotentialNodes().contains(i)) continue;
            this.connectedGraph.addArc(this.n, i);
        }
        this.connectedGraph.addArc(this.n, this.root);
    }

    protected void explore() {
        this.visited.clear();
        int first = 0;
        int last = 0;
        int i = this.root;
        this.fifo[last++] = i;
        this.visited.set(i);
        while (first < last) {
            i = this.fifo[first++];
            ISetIterator iSetIterator = this.g.getPotSuccOf(i).iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (this.visited.get(j)) continue;
                this.visited.set(j);
                this.fifo[last++] = j;
            }
        }
    }
}

