/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.symmbreaking;

import java.util.HashSet;
import org.chocosolver.graphsolver.variables.DirectedGraphVar;
import org.chocosolver.graphsolver.variables.GraphEventType;
import org.chocosolver.graphsolver.variables.delta.GraphDeltaMonitor;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.PairProcedure;
import org.chocosolver.util.tools.ArrayUtils;

public class PropIncrementalAdjacencyMatrix
extends Propagator<Variable> {
    private DirectedGraphVar graph;
    private GraphDeltaMonitor gdm;
    private PairProcedure enforce;
    private PairProcedure remove;
    private int n;
    private BoolVar[] t;

    public PropIncrementalAdjacencyMatrix(DirectedGraphVar graphVar, BoolVar[] t) {
        super((Variable[])ArrayUtils.append((Object[][])new Variable[][]{{graphVar}, t}), PropagatorPriority.LINEAR, true);
        this.graph = graphVar;
        this.gdm = this.graph.monitorDelta((ICause)this);
        this.enforce = (from, to) -> t[from + to * this.n].instantiateTo(1, (ICause)this);
        this.remove = (from, to) -> t[from + to * this.n].instantiateTo(0, (ICause)this);
        this.n = graphVar.getNbMaxNodes();
        this.t = t;
    }

    public void propagate(int evtmask) throws ContradictionException {
        this.propagateGraphChanged();
        this.propagateTChanged();
        this.gdm.unfreeze();
    }

    private void propagateGraphChanged() throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (this.t[i + j * this.n].isInstantiatedTo(1)) {
                    this.graph.enforceArc(i, j, (ICause)this);
                }
                if (!this.t[i + j * this.n].isInstantiatedTo(0)) continue;
                this.graph.removeArc(i, j, (ICause)this);
            }
        }
    }

    private void propagateTChanged() throws ContradictionException {
        int v2;
        int u;
        for (u = 0; u < this.n; ++u) {
            ISetIterator iSetIterator = this.graph.getMandSuccOf(u).iterator();
            while (iSetIterator.hasNext()) {
                v2 = (Integer)iSetIterator.next();
                this.t[u + v2 * this.n].instantiateTo(1, (ICause)this);
            }
        }
        for (u = 0; u < this.n; ++u) {
            HashSet<Integer> set = new HashSet<Integer>();
            ISetIterator v2 = this.graph.getPotSuccOf(u).iterator();
            while (v2.hasNext()) {
                int v3 = (Integer)v2.next();
                set.add(v3);
            }
            for (v2 = 0; v2 < this.n; ++v2) {
                if (set.contains(v2)) continue;
                this.t[u + v2 * this.n].instantiateTo(0, (ICause)this);
            }
        }
    }

    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (idxVarInProp == 0) {
            this.gdm.freeze();
            this.gdm.forEachArc(this.enforce, GraphEventType.ADD_ARC);
            this.gdm.forEachArc(this.remove, GraphEventType.REMOVE_ARC);
            this.gdm.unfreeze();
        } else {
            this.propagateTChanged();
        }
    }

    public int getPropagationConditions(int vIdx) {
        if (vIdx == 0) {
            return GraphEventType.ADD_ARC.getMask() | GraphEventType.REMOVE_ARC.getMask();
        }
        return IntEventType.boundAndInst();
    }

    public ESat isEntailed() {
        int j;
        ISet children;
        int i;
        for (i = 0; i < this.n; ++i) {
            children = this.graph.getMandSuccOf(i);
            for (j = 0; j < this.n; ++j) {
                if (!this.t[i + j * this.n].isInstantiatedTo(0) || !children.contains(j)) continue;
                return ESat.FALSE;
            }
        }
        for (i = 0; i < this.n; ++i) {
            children = this.graph.getPotSuccOf(i);
            for (j = 0; j < this.n; ++j) {
                if (!this.t[i + j * this.n].isInstantiatedTo(1) || children.contains(j)) continue;
                return ESat.FALSE;
            }
        }
        if (this.graph.isInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

