/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.symmbreaking;

import java.util.HashSet;
import org.chocosolver.graphsolver.cstrs.symmbreaking.Pair;
import org.chocosolver.graphsolver.variables.UndirectedGraphVar;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropGirth
extends Propagator<Variable> {
    private UndirectedGraphVar graph;
    private int n;
    private IntVar girth;

    public PropGirth(UndirectedGraphVar graphVar, IntVar girth) {
        super(new Variable[]{girth, graphVar}, PropagatorPriority.LINEAR, false);
        this.graph = graphVar;
        this.n = graphVar.getNbMaxNodes();
        this.girth = girth;
    }

    public void propagate(int evtmask) throws ContradictionException {
        int upperGraphGirth = this.getUpperGraphGirth();
        int lowerGraphGirth = this.getLowerGraphGirth();
        if (upperGraphGirth < this.girth.getUB()) {
            this.girth.updateUpperBound(upperGraphGirth, (ICause)this);
        }
        if (upperGraphGirth < this.girth.getLB()) {
            throw new ContradictionException();
        }
        if (lowerGraphGirth > this.girth.getLB()) {
            this.girth.updateLowerBound(lowerGraphGirth, (ICause)this);
        }
        if (lowerGraphGirth > this.girth.getUB()) {
            throw new ContradictionException();
        }
    }

    public ESat isEntailed() {
        int upperGraphGirth = this.getUpperGraphGirth();
        int lowerGraphGirth = this.getLowerGraphGirth();
        if (upperGraphGirth < this.girth.getLB()) {
            return ESat.FALSE;
        }
        if (lowerGraphGirth > this.girth.getUB()) {
            return ESat.FALSE;
        }
        if (this.graph.isInstantiated() && this.girth.isInstantiatedTo(lowerGraphGirth)) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    private int getUpperGraphGirth() {
        int g = this.n + 1;
        for (int i = 0; i < this.n; ++i) {
            int pg = this.getUpperGraphGirth(i);
            if (pg >= g) continue;
            g = pg;
        }
        return g;
    }

    private int getLowerGraphGirth() {
        int g = this.n + 1;
        for (int i = 0; i < this.n; ++i) {
            int pg = this.getLowerGraphGirth(i);
            if (pg >= g) continue;
            g = pg;
        }
        return g;
    }

    private int getUpperGraphGirth(int vertex) {
        HashSet<Pair<Integer, Integer>> reachable = new HashSet<Pair<Integer, Integer>>();
        reachable.add(new Pair<Integer, Integer>(vertex, -1));
        for (int i = 1; i <= this.n; ++i) {
            HashSet set = new HashSet();
            for (Pair pair : reachable) {
                ISetIterator iSetIterator = this.graph.getMandNeighOf((Integer)pair.getA()).iterator();
                while (iSetIterator.hasNext()) {
                    int v = (Integer)iSetIterator.next();
                    if (v == (Integer)pair.getB()) continue;
                    if (v == vertex) {
                        return i;
                    }
                    set.add(new Pair(v, pair.getA()));
                }
            }
            reachable = set;
        }
        return this.n + 1;
    }

    private int getLowerGraphGirth(int vertex) {
        HashSet<Pair<Integer, Integer>> reachable = new HashSet<Pair<Integer, Integer>>();
        reachable.add(new Pair<Integer, Integer>(vertex, -1));
        for (int i = 1; i <= this.n; ++i) {
            HashSet set = new HashSet();
            for (Pair pair : reachable) {
                ISetIterator iSetIterator = this.graph.getPotNeighOf((Integer)pair.getA()).iterator();
                while (iSetIterator.hasNext()) {
                    int v = (Integer)iSetIterator.next();
                    if (v == (Integer)pair.getB()) continue;
                    if (v == vertex) {
                        return i;
                    }
                    set.add(new Pair(v, pair.getA()));
                }
            }
            reachable = set;
        }
        return this.n + 1;
    }
}

