/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.inclusion;

import org.chocosolver.graphsolver.variables.GraphEventType;
import org.chocosolver.graphsolver.variables.GraphVar;
import org.chocosolver.graphsolver.variables.delta.GraphDeltaMonitor;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.procedure.PairProcedure;

public class PropInclusion
extends Propagator<GraphVar> {
    private GraphVar[] g;
    private GraphDeltaMonitor[] gdm;
    private IntProcedure[] prNode;
    private PairProcedure[] prArc;
    private GraphEventType[] etNode;
    private GraphEventType[] etArcs;

    public PropInclusion(GraphVar g1, GraphVar g2) {
        super((Variable[])new GraphVar[]{g1, g2}, PropagatorPriority.LINEAR, true);
        this.g = new GraphVar[]{g1, g2};
        this.gdm = new GraphDeltaMonitor[]{g1.monitorDelta((ICause)this), g2.monitorDelta((ICause)this)};
        this.prNode = new IntProcedure[]{i -> this.g[1].enforceNode(i, (ICause)this), i -> this.g[0].removeNode(i, (ICause)this)};
        this.prArc = new PairProcedure[]{(i, j) -> this.g[1].enforceArc(i, j, (ICause)this), (i, j) -> this.g[0].removeArc(i, j, (ICause)this)};
        this.etNode = new GraphEventType[]{GraphEventType.ADD_NODE, GraphEventType.REMOVE_NODE};
        this.etArcs = new GraphEventType[]{GraphEventType.ADD_ARC, GraphEventType.REMOVE_ARC};
    }

    public void propagate(int evtmask) throws ContradictionException {
        int j;
        ISetIterator iSetIterator;
        ISet suc;
        int i;
        if (this.g[0].getNbMaxNodes() != this.g[1].getNbMaxNodes()) {
            for (int i2 = this.g[1].getNbMaxNodes(); i2 < this.g[0].getNbMaxNodes(); ++i2) {
                this.g[0].removeNode(i2, (ICause)this);
            }
        }
        ISet set = this.g[0].getMandatoryNodes();
        ISetIterator iSetIterator2 = set.iterator();
        while (iSetIterator2.hasNext()) {
            i = (Integer)iSetIterator2.next();
            this.g[1].enforceNode(i, (ICause)this);
            suc = this.g[0].getMandSuccOrNeighOf(i);
            iSetIterator = suc.iterator();
            while (iSetIterator.hasNext()) {
                j = (Integer)iSetIterator.next();
                this.g[1].enforceArc(i, j, (ICause)this);
            }
        }
        set = this.g[0].getPotentialNodes();
        iSetIterator2 = set.iterator();
        while (iSetIterator2.hasNext()) {
            i = (Integer)iSetIterator2.next();
            if (!this.g[1].getPotentialNodes().contains(i)) {
                this.g[0].removeNode(i, (ICause)this);
                continue;
            }
            suc = this.g[0].getPotSuccOrNeighOf(i);
            iSetIterator = suc.iterator();
            while (iSetIterator.hasNext()) {
                j = (Integer)iSetIterator.next();
                if (this.g[1].getPotSuccOrNeighOf(i).contains(j)) continue;
                this.g[1].removeArc(i, j, (ICause)this);
            }
        }
        this.gdm[0].unfreeze();
        this.gdm[1].unfreeze();
    }

    public void propagate(int vIdx, int evtmask) throws ContradictionException {
        this.gdm[vIdx].freeze();
        this.gdm[vIdx].forEachNode(this.prNode[vIdx], this.etNode[vIdx]);
        this.gdm[vIdx].forEachArc(this.prArc[vIdx], this.etArcs[vIdx]);
        this.gdm[vIdx].unfreeze();
    }

    public ESat isEntailed() {
        return null;
    }
}

