/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.degree;

import java.util.BitSet;
import org.chocosolver.graphsolver.variables.DirectedGraphVar;
import org.chocosolver.graphsolver.variables.GraphVar;
import org.chocosolver.graphsolver.variables.IncidentSet;
import org.chocosolver.graphsolver.variables.UndirectedGraphVar;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.graphs.Orientation;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.tools.ArrayUtils;

public class PropNodeDegree_Var
extends Propagator<Variable> {
    private int n;
    private GraphVar g;
    private IntVar[] degrees;
    private IncidentSet target;
    private BitSet toDo;

    public PropNodeDegree_Var(DirectedGraphVar graph, Orientation setType, IntVar[] degrees) {
        super((Variable[])ArrayUtils.append((Object[][])new Variable[][]{degrees, {graph}}), PropagatorPriority.BINARY, false);
        this.g = graph;
        this.n = this.g.getNbMaxNodes();
        this.degrees = degrees;
        this.target = setType == Orientation.PREDECESSORS ? new IncidentSet.PredOrNeighSet() : new IncidentSet.SuccOrNeighSet();
    }

    public PropNodeDegree_Var(UndirectedGraphVar graph, IntVar[] degrees) {
        super((Variable[])ArrayUtils.append((Object[][])new Variable[][]{degrees, {graph}}), PropagatorPriority.BINARY, false);
        this.target = new IncidentSet.SuccOrNeighSet();
        this.g = graph;
        this.n = this.g.getNbMaxNodes();
        this.degrees = degrees;
        this.toDo = new BitSet(this.n);
    }

    public void propagate(int evtmask) throws ContradictionException {
        if (this.g.isDirected()) {
            this.propagateDirected();
        } else {
            this.propagateUndirected();
        }
    }

    public void propagateDirected() throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            int s;
            ISetIterator iSetIterator;
            if (!this.g.getPotentialNodes().contains(i)) {
                this.degrees[i].instantiateTo(0, (ICause)this);
            } else if (this.degrees[i].getLB() > 0) {
                this.g.enforceNode(i, (ICause)this);
            }
            ISet env = this.target.getPotSet(this.g, i);
            ISet ker = this.target.getMandSet(this.g, i);
            this.degrees[i].updateLowerBound(ker.size(), (ICause)this);
            this.degrees[i].updateUpperBound(env.size(), (ICause)this);
            if (ker.size() >= env.size() || !this.degrees[i].isInstantiated()) continue;
            int d = this.degrees[i].getValue();
            if (env.size() == d) {
                iSetIterator = env.iterator();
                while (iSetIterator.hasNext()) {
                    s = (Integer)iSetIterator.next();
                    this.target.enforce(this.g, i, s, (ICause)this);
                }
                continue;
            }
            if (ker.size() != d) continue;
            iSetIterator = env.iterator();
            while (iSetIterator.hasNext()) {
                s = (Integer)iSetIterator.next();
                if (ker.contains(s)) continue;
                this.target.remove(this.g, i, s, (ICause)this);
            }
        }
    }

    public void propagateUndirected() throws ContradictionException {
        int i;
        assert (!this.g.isDirected());
        this.toDo.clear();
        for (i = 0; i < this.n; ++i) {
            this.toDo.set(i);
        }
        i = this.toDo.nextSetBit(0);
        do {
            int s;
            ISetIterator iSetIterator;
            this.toDo.clear(i);
            if (!this.g.getPotentialNodes().contains(i)) {
                this.degrees[i].instantiateTo(0, (ICause)this);
            } else if (this.degrees[i].getLB() > 0) {
                this.g.enforceNode(i, (ICause)this);
            }
            ISet env = this.target.getPotSet(this.g, i);
            ISet ker = this.target.getMandSet(this.g, i);
            this.degrees[i].updateLowerBound(ker.size(), (ICause)this);
            this.degrees[i].updateUpperBound(env.size(), (ICause)this);
            if (ker.size() >= env.size() || !this.degrees[i].isInstantiated()) continue;
            int d = this.degrees[i].getValue();
            if (env.size() == d) {
                iSetIterator = env.iterator();
                while (iSetIterator.hasNext()) {
                    s = (Integer)iSetIterator.next();
                    if (!this.target.enforce(this.g, i, s, (ICause)this)) continue;
                    this.toDo.set(s);
                }
            } else {
                if (ker.size() != d) continue;
                iSetIterator = env.iterator();
                while (iSetIterator.hasNext()) {
                    s = (Integer)iSetIterator.next();
                    if (ker.contains(s) || !this.target.remove(this.g, i, s, (ICause)this)) continue;
                    this.toDo.set(s);
                }
            }
        } while ((i = this.toDo.nextSetBit(0)) >= 0);
    }

    public ESat isEntailed() {
        boolean done = true;
        for (int i = 0; i < this.n; ++i) {
            if (!this.degrees[i].contains(0) && !this.g.getPotentialNodes().contains(i)) {
                return ESat.FALSE;
            }
            ISet env = this.target.getPotSet(this.g, i);
            ISet ker = this.target.getMandSet(this.g, i);
            if (this.degrees[i].getLB() > env.size() || this.degrees[i].getUB() < ker.size()) {
                return ESat.FALSE;
            }
            if (env.size() == ker.size() && this.degrees[i].isInstantiated()) continue;
            done = false;
        }
        if (!done) {
            return ESat.UNDEFINED;
        }
        return ESat.TRUE;
    }
}

