/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.degree;

import org.chocosolver.graphsolver.variables.DirectedGraphVar;
import org.chocosolver.graphsolver.variables.GraphEventType;
import org.chocosolver.graphsolver.variables.GraphVar;
import org.chocosolver.graphsolver.variables.IncidentSet;
import org.chocosolver.graphsolver.variables.UndirectedGraphVar;
import org.chocosolver.graphsolver.variables.delta.GraphDeltaMonitor;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.graphs.Orientation;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.procedure.PairProcedure;

public class PropNodeDegree_AtLeast_Incr
extends Propagator<GraphVar> {
    private GraphVar g;
    private int[] degrees;
    private IncidentSet target;
    private GraphDeltaMonitor gdm;
    private PairProcedure proc;
    private IntProcedure nodeProc;

    public PropNodeDegree_AtLeast_Incr(DirectedGraphVar graph, Orientation setType, int degree) {
        this(graph, setType, PropNodeDegree_AtLeast_Incr.buildArray(degree, graph.getNbMaxNodes()));
    }

    public PropNodeDegree_AtLeast_Incr(DirectedGraphVar graph, Orientation setType, int[] degrees) {
        super((Variable[])new DirectedGraphVar[]{graph}, PropagatorPriority.BINARY, true);
        this.g = graph;
        this.degrees = degrees;
        switch (setType) {
            case SUCCESSORS: {
                this.target = new IncidentSet.SuccOrNeighSet();
                this.proc = (i, j) -> this.checkAtLeast(i);
                break;
            }
            case PREDECESSORS: {
                this.target = new IncidentSet.PredOrNeighSet();
                this.proc = (i, j) -> this.checkAtLeast(j);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.nodeProc = this::checkAtLeast;
        this.gdm = this.g.monitorDelta((ICause)this);
    }

    public PropNodeDegree_AtLeast_Incr(UndirectedGraphVar graph, int degree) {
        this(graph, PropNodeDegree_AtLeast_Incr.buildArray(degree, graph.getNbMaxNodes()));
    }

    public PropNodeDegree_AtLeast_Incr(UndirectedGraphVar graph, int[] degrees) {
        super((Variable[])new UndirectedGraphVar[]{graph}, PropagatorPriority.BINARY, true);
        this.target = new IncidentSet.SuccOrNeighSet();
        this.g = graph;
        this.degrees = degrees;
        this.gdm = this.g.monitorDelta((ICause)this);
        this.proc = (i, j) -> {
            this.checkAtLeast(i);
            this.checkAtLeast(j);
        };
        this.nodeProc = this::checkAtLeast;
    }

    private static int[] buildArray(int degree, int n) {
        int[] degrees = new int[n];
        for (int i = 0; i < n; ++i) {
            degrees[i] = degree;
        }
        return degrees;
    }

    public void propagate(int evtmask) throws ContradictionException {
        ISet act = this.g.getPotentialNodes();
        ISetIterator iSetIterator = act.iterator();
        while (iSetIterator.hasNext()) {
            int node = (Integer)iSetIterator.next();
            this.checkAtLeast(node);
        }
        this.gdm.unfreeze();
    }

    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.gdm.freeze();
        this.gdm.forEachNode(this.nodeProc, GraphEventType.ADD_NODE);
        this.gdm.forEachArc(this.proc, GraphEventType.REMOVE_ARC);
        this.gdm.unfreeze();
    }

    public int getPropagationConditions(int vIdx) {
        return GraphEventType.REMOVE_ARC.getMask() + GraphEventType.ADD_NODE.getMask();
    }

    public ESat isEntailed() {
        ISet act = this.g.getMandatoryNodes();
        ISetIterator iSetIterator = act.iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            if (this.target.getPotSet(this.g, i).size() >= this.degrees[i]) continue;
            return ESat.FALSE;
        }
        if (!this.g.isInstantiated()) {
            return ESat.UNDEFINED;
        }
        return ESat.TRUE;
    }

    private void checkAtLeast(int i) throws ContradictionException {
        ISet pot = this.target.getPotSet(this.g, i);
        ISet ker = this.target.getMandSet(this.g, i);
        int potSize = pot.size();
        if (potSize < this.degrees[i]) {
            this.g.removeNode(i, (ICause)this);
        } else if (potSize == this.degrees[i] && this.g.getMandatoryNodes().contains(i) && ker.size() < potSize) {
            ISetIterator iSetIterator = pot.iterator();
            while (iSetIterator.hasNext()) {
                int s = (Integer)iSetIterator.next();
                this.target.enforce(this.g, i, s, (ICause)this);
            }
        }
    }
}

