/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.degree;

import org.chocosolver.graphsolver.variables.DirectedGraphVar;
import org.chocosolver.graphsolver.variables.GraphEventType;
import org.chocosolver.graphsolver.variables.GraphVar;
import org.chocosolver.graphsolver.variables.IncidentSet;
import org.chocosolver.graphsolver.variables.UndirectedGraphVar;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.graphs.Orientation;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropNodeDegree_AtLeast_Coarse
extends Propagator<GraphVar> {
    private GraphVar g;
    private int[] degrees;
    private IncidentSet target;

    public PropNodeDegree_AtLeast_Coarse(DirectedGraphVar graph, Orientation setType, int degree) {
        this(graph, setType, PropNodeDegree_AtLeast_Coarse.buildArray(degree, graph.getNbMaxNodes()));
    }

    public PropNodeDegree_AtLeast_Coarse(DirectedGraphVar graph, Orientation setType, int[] degrees) {
        super((Variable[])new DirectedGraphVar[]{graph}, PropagatorPriority.BINARY, false);
        this.g = graph;
        this.degrees = degrees;
        switch (setType) {
            case SUCCESSORS: {
                this.target = new IncidentSet.SuccOrNeighSet();
                break;
            }
            case PREDECESSORS: {
                this.target = new IncidentSet.PredOrNeighSet();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public PropNodeDegree_AtLeast_Coarse(UndirectedGraphVar graph, int degree) {
        this(graph, PropNodeDegree_AtLeast_Coarse.buildArray(degree, graph.getNbMaxNodes()));
    }

    public PropNodeDegree_AtLeast_Coarse(UndirectedGraphVar graph, int[] degrees) {
        super((Variable[])new UndirectedGraphVar[]{graph}, PropagatorPriority.BINARY, false);
        this.target = new IncidentSet.SuccOrNeighSet();
        this.g = graph;
        this.degrees = degrees;
    }

    private static int[] buildArray(int degree, int n) {
        int[] degrees = new int[n];
        for (int i = 0; i < n; ++i) {
            degrees[i] = degree;
        }
        return degrees;
    }

    public void propagate(int evtmask) throws ContradictionException {
        ISetIterator iSetIterator = this.g.getPotentialNodes().iterator();
        while (iSetIterator.hasNext()) {
            int node = (Integer)iSetIterator.next();
            this.checkAtLeast(node);
        }
    }

    public int getPropagationConditions(int vIdx) {
        return GraphEventType.REMOVE_ARC.getMask() + GraphEventType.ADD_NODE.getMask();
    }

    public ESat isEntailed() {
        ISet act = this.g.getMandatoryNodes();
        ISetIterator iSetIterator = act.iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            if (this.target.getPotSet(this.g, i).size() >= this.degrees[i]) continue;
            return ESat.FALSE;
        }
        if (!this.g.isInstantiated()) {
            return ESat.UNDEFINED;
        }
        return ESat.TRUE;
    }

    private void checkAtLeast(int i) throws ContradictionException {
        ISet nei = this.target.getPotSet(this.g, i);
        ISet ker = this.target.getMandSet(this.g, i);
        int size = nei.size();
        if (size < this.degrees[i]) {
            this.g.removeNode(i, (ICause)this);
        } else if (size == this.degrees[i] && this.g.getMandatoryNodes().contains(i) && ker.size() < size) {
            ISetIterator iSetIterator = nei.iterator();
            while (iSetIterator.hasNext()) {
                int s = (Integer)iSetIterator.next();
                this.target.enforce(this.g, i, s, (ICause)this);
            }
        }
    }
}

