/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.cycles;

import org.chocosolver.graphsolver.variables.DirectedGraphVar;
import org.chocosolver.graphsolver.variables.GraphEventType;
import org.chocosolver.graphsolver.variables.delta.GraphDeltaMonitor;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.procedure.PairProcedure;

public class PropPathNoCircuit
extends Propagator<DirectedGraphVar> {
    private DirectedGraphVar g;
    private GraphDeltaMonitor gdm;
    private int n;
    private PairProcedure arcEnforced;
    private IStateInt[] origin;
    private IStateInt[] end;
    private IStateInt[] size;

    public PropPathNoCircuit(DirectedGraphVar graph) {
        super((Variable[])new DirectedGraphVar[]{graph}, PropagatorPriority.LINEAR, true);
        this.g = graph;
        this.gdm = this.g.monitorDelta((ICause)this);
        this.n = this.g.getNbMaxNodes();
        this.arcEnforced = new EnfArc();
        this.origin = new IStateInt[this.n];
        this.size = new IStateInt[this.n];
        this.end = new IStateInt[this.n];
        IEnvironment environment = graph.getEnvironment();
        for (int i = 0; i < this.n; ++i) {
            this.origin[i] = environment.makeInt(i);
            this.size[i] = environment.makeInt(1);
            this.end[i] = environment.makeInt(i);
        }
    }

    public void propagate(int evtmask) throws ContradictionException {
        int i;
        for (i = 0; i < this.n; ++i) {
            this.end[i].set(i);
            this.origin[i].set(i);
            this.size[i].set(1);
        }
        for (i = 0; i < this.n; ++i) {
            ISet succs = this.g.getMandSuccOf(i);
            if (succs.size() <= 0) continue;
            if (succs.size() > 1) {
                this.fails();
                continue;
            }
            this.enforce(i, this.g.getMandSuccOf(i).iterator().next());
        }
        this.gdm.unfreeze();
    }

    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.gdm.freeze();
        this.gdm.forEachArc(this.arcEnforced, GraphEventType.ADD_ARC);
        this.gdm.unfreeze();
    }

    public int getPropagationConditions(int vIdx) {
        return GraphEventType.ADD_ARC.getMask();
    }

    public ESat isEntailed() {
        System.out.println("[WARNING] " + ((Object)((Object)this)).getClass().getSimpleName() + ".isEntail() is not implemented yet and returns true by default. Please do not reify this constraint ");
        return ESat.TRUE;
    }

    private void enforce(int i, int j) throws ContradictionException {
        int last = this.end[j].get();
        int start = this.origin[i].get();
        if (this.origin[j].get() != j) {
            this.fails();
        }
        this.g.removeArc(last, start, (ICause)this);
        this.origin[last].set(start);
        this.end[start].set(last);
        this.size[start].add(this.size[j].get());
    }

    private class EnfArc
    implements PairProcedure {
        private EnfArc() {
        }

        public void execute(int i, int j) throws ContradictionException {
            PropPathNoCircuit.this.enforce(i, j);
        }
    }
}

