/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.cycles;

import org.chocosolver.graphsolver.variables.GraphEventType;
import org.chocosolver.graphsolver.variables.UndirectedGraphVar;
import org.chocosolver.graphsolver.variables.delta.GraphDeltaMonitor;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.PairProcedure;

public class PropHamiltonianCycle
extends Propagator<UndirectedGraphVar> {
    private UndirectedGraphVar g;
    private GraphDeltaMonitor gdm;
    private int n;
    private PairProcedure arcEnforced;
    private IStateInt[] e1;
    private IStateInt[] e2;
    private IStateInt[] size;

    public PropHamiltonianCycle(UndirectedGraphVar graph) {
        super((Variable[])new UndirectedGraphVar[]{graph}, PropagatorPriority.LINEAR, true);
        this.g = graph;
        this.gdm = this.g.monitorDelta((ICause)this);
        this.n = this.g.getNbMaxNodes();
        this.arcEnforced = new EnfArc();
        this.e1 = new IStateInt[this.n];
        this.e2 = new IStateInt[this.n];
        this.size = new IStateInt[this.n];
        IEnvironment environment = graph.getEnvironment();
        for (int i = 0; i < this.n; ++i) {
            this.e1[i] = environment.makeInt(i);
            this.e2[i] = environment.makeInt(i);
            this.size[i] = environment.makeInt(1);
        }
    }

    public void propagate(int evtmask) throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            this.e1[i].set(i);
            this.e2[i].set(i);
            this.size[i].set(1);
            this.g.enforceNode(i, (ICause)this);
        }
        for (int i = 0; i < this.n; ++i) {
            ISet nei = this.g.getMandNeighOf(i);
            ISetIterator iSetIterator = nei.iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (i >= j) continue;
                this.enforce(i, j);
            }
        }
        this.gdm.unfreeze();
    }

    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.gdm.freeze();
        this.gdm.forEachArc(this.arcEnforced, GraphEventType.ADD_ARC);
        this.gdm.unfreeze();
    }

    public int getPropagationConditions(int vIdx) {
        return GraphEventType.ADD_ARC.getMask();
    }

    public ESat isEntailed() {
        ISet nodes = this.g.getMandatoryNodes();
        ISetIterator iSetIterator = nodes.iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            if (this.g.getMandNeighOf(i).size() <= 2 && this.g.getPotNeighOf(i).size() >= 2) continue;
            return ESat.FALSE;
        }
        if (this.g.isInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    private void enforce(int i, int j) throws ContradictionException {
        int ext1 = this.getExt(i);
        int ext2 = this.getExt(j);
        int t = this.size[ext1].get() + this.size[ext2].get();
        this.setExt(ext1, ext2);
        this.setExt(ext2, ext1);
        this.size[ext1].set(t);
        this.size[ext2].set(t);
        if (t > 2 && t <= this.n) {
            if (t < this.n) {
                this.g.removeArc(ext1, ext2, (ICause)this);
            } else if (t == this.n) {
                this.g.enforceArc(ext1, ext2, (ICause)this);
            }
        }
    }

    private int getExt(int i) {
        return this.e1[i].get() == i ? this.e2[i].get() : this.e1[i].get();
    }

    private void setExt(int i, int ext) {
        if (this.e1[i].get() == i) {
            this.e2[i].set(ext);
        } else {
            this.e1[i].set(ext);
        }
    }

    protected class EnfArc
    implements PairProcedure {
        protected EnfArc() {
        }

        public void execute(int i, int j) throws ContradictionException {
            PropHamiltonianCycle.this.enforce(i, j);
        }
    }
}

