/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.cycles;

import java.util.BitSet;
import org.chocosolver.graphsolver.variables.GraphEventType;
import org.chocosolver.graphsolver.variables.GraphVar;
import org.chocosolver.graphsolver.variables.delta.GraphDeltaMonitor;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.PairProcedure;

public class PropACyclic
extends Propagator<GraphVar> {
    private GraphVar g;
    private GraphDeltaMonitor gdm;
    private PairProcedure arcEnf;
    private int n;
    private BitSet rfFrom;
    private BitSet rfTo;
    private int[] fifo;

    public PropACyclic(GraphVar g) {
        super((Variable[])new GraphVar[]{g}, PropagatorPriority.LINEAR, true);
        this.g = g;
        this.n = g.getNbMaxNodes();
        this.fifo = new int[this.n];
        this.rfFrom = new BitSet(this.n);
        this.rfTo = new BitSet(this.n);
        this.gdm = g.monitorDelta((ICause)this);
        this.arcEnf = this::propagateIJ;
    }

    public int getPropagationConditions(int idx) {
        return GraphEventType.ADD_ARC.getMask();
    }

    public void propagate(int evtmask) throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            this.g.removeArc(i, i, (ICause)this);
            if (this.g.getMandSuccOrNeighOf(i).size() <= 0) continue;
            for (int j = 0; j < this.n; ++j) {
                if (!this.g.getMandSuccOrNeighOf(i).contains(j)) continue;
                this.propagateIJ(i, j);
            }
        }
        this.gdm.unfreeze();
    }

    public void propagate(int idx, int mask) throws ContradictionException {
        this.gdm.freeze();
        this.gdm.forEachArc(this.arcEnf, GraphEventType.ADD_ARC);
        this.gdm.unfreeze();
    }

    public void propagateIJ(int from, int to) throws ContradictionException {
        int j;
        ISetIterator iSetIterator;
        ISet nei;
        if (this.g.isDirected()) {
            this.g.removeArc(to, from, (ICause)this);
        }
        int first = 0;
        int last = 0;
        int ik = to;
        this.rfTo.clear();
        this.fifo[last++] = ik;
        this.rfTo.set(ik);
        while (first < last) {
            ik = this.fifo[first++];
            nei = this.g.getMandSuccOrNeighOf(ik);
            iSetIterator = nei.iterator();
            while (iSetIterator.hasNext()) {
                j = (Integer)iSetIterator.next();
                if (j == from || this.rfTo.get(j)) continue;
                this.rfTo.set(j);
                this.fifo[last++] = j;
            }
        }
        first = 0;
        last = 0;
        ik = from;
        this.rfFrom.clear();
        this.fifo[last++] = ik;
        this.rfFrom.set(ik);
        while (first < last) {
            ik = this.fifo[first++];
            nei = this.g.getMandPredOrNeighOf(ik);
            iSetIterator = nei.iterator();
            while (iSetIterator.hasNext()) {
                j = (Integer)iSetIterator.next();
                if (j == to || this.rfFrom.get(j)) continue;
                this.rfFrom.set(j);
                this.fifo[last++] = j;
            }
        }
        ISetIterator iSetIterator2 = this.g.getPotentialNodes().iterator();
        while (iSetIterator2.hasNext()) {
            int i = (Integer)iSetIterator2.next();
            if (!this.rfTo.get(i)) continue;
            ISet nei2 = this.g.getPotSuccOrNeighOf(i);
            ISetIterator iSetIterator3 = nei2.iterator();
            while (iSetIterator3.hasNext()) {
                int j2 = (Integer)iSetIterator3.next();
                if (!this.rfFrom.get(j2) || i == from && j2 == to || i == to && j2 == from) continue;
                this.g.removeArc(i, j2, (ICause)this);
            }
        }
    }

    public ESat isEntailed() {
        for (int from = 0; from < this.n; ++from) {
            ISet neigh = this.g.getMandSuccOrNeighOf(from);
            ISetIterator iSetIterator = neigh.iterator();
            while (iSetIterator.hasNext()) {
                int j;
                ISetIterator iSetIterator2;
                ISet nei;
                int to = (Integer)iSetIterator.next();
                int first = 0;
                int last = 0;
                int ik = to;
                this.rfTo.clear();
                this.fifo[last++] = ik;
                this.rfTo.set(ik);
                while (first < last) {
                    ik = this.fifo[first++];
                    nei = this.g.getMandSuccOrNeighOf(ik);
                    iSetIterator2 = nei.iterator();
                    while (iSetIterator2.hasNext()) {
                        j = (Integer)iSetIterator2.next();
                        if (j == from || this.rfTo.get(j)) continue;
                        this.rfTo.set(j);
                        this.fifo[last++] = j;
                    }
                }
                first = 0;
                last = 0;
                ik = from;
                this.rfFrom.clear();
                this.fifo[last++] = ik;
                this.rfFrom.set(ik);
                while (first < last) {
                    ik = this.fifo[first++];
                    nei = this.g.getMandPredOrNeighOf(ik);
                    iSetIterator2 = nei.iterator();
                    while (iSetIterator2.hasNext()) {
                        j = (Integer)iSetIterator2.next();
                        if (j == to || this.rfFrom.get(j)) continue;
                        this.rfFrom.set(j);
                        this.fifo[last++] = j;
                    }
                }
                ISetIterator iSetIterator3 = this.g.getMandatoryNodes().iterator();
                while (iSetIterator3.hasNext()) {
                    int i = (Integer)iSetIterator3.next();
                    if (!this.rfTo.get(i)) continue;
                    ISet nei2 = this.g.getMandSuccOrNeighOf(i);
                    ISetIterator iSetIterator4 = nei2.iterator();
                    while (iSetIterator4.hasNext()) {
                        int j2 = (Integer)iSetIterator4.next();
                        if (!this.rfFrom.get(j2) || i == from && j2 == to || i == to && j2 == from) continue;
                        return ESat.FALSE;
                    }
                }
            }
        }
        if (!this.isCompletelyInstantiated()) {
            return ESat.UNDEFINED;
        }
        return ESat.TRUE;
    }
}

