/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.cost.tsp.lagrangianRelaxation;

import org.chocosolver.graphsolver.cstrs.cost.tsp.lagrangianRelaxation.PropLagr_OneTree;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.tools.ArrayUtils;

public class PropLagr_OneTree_IntVar
extends PropLagr_OneTree {
    protected IntVar[] succ;

    public PropLagr_OneTree_IntVar(IntVar[] graph, IntVar cost, int[][] costMatrix, boolean waitFirstSol) {
        super((Variable[])ArrayUtils.append((IntVar[][])new IntVar[][]{graph, {cost}}), costMatrix);
        this.succ = graph;
        this.g = new UndirectedGraph(this.n, SetType.BIPARTITESET, true);
        this.obj = cost;
        this.waitFirstSol = waitFirstSol;
        assert (PropLagr_OneTree_IntVar.checkSymmetry(costMatrix)) : "TSP matrix should be symmetric";
    }

    @Override
    protected void rebuild() {
        int i;
        this.mandatoryArcsList.clear();
        for (i = 0; i < this.n; ++i) {
            this.g.getNeighOf(i).clear();
            if (!this.succ[i].isInstantiated()) continue;
            int j = this.succ[i].getValue();
            this.mandatoryArcsList.add(i * this.n + j);
        }
        for (i = 0; i < this.n; ++i) {
            IntVar v = this.succ[i];
            int ub = v.getUB();
            int j = v.getLB();
            while (j <= ub) {
                this.g.addEdge(i, j);
                j = v.nextValue(j);
            }
        }
    }

    @Override
    public void remove(int from, int to) throws ContradictionException {
        this.succ[from].removeValue(to, (ICause)this);
        this.succ[to].removeValue(from, (ICause)this);
    }

    @Override
    public void enforce(int from, int to) throws ContradictionException {
        if (!this.succ[from].contains(to)) {
            this.succ[to].instantiateTo(from, (ICause)this);
        }
        if (!this.succ[to].contains(from)) {
            this.succ[from].instantiateTo(to, (ICause)this);
        }
    }

    @Override
    public ESat isEntailed() {
        return ESat.TRUE;
    }

    @Override
    public boolean isMandatory(int i, int j) {
        return this.succ[i].isInstantiatedTo(j) || this.succ[j].isInstantiatedTo(i);
    }

    public static boolean checkSymmetry(int[][] costMatrix) {
        int n = costMatrix.length;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (costMatrix[i][j] == costMatrix[j][i]) continue;
                return false;
            }
        }
        return true;
    }
}

