/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.cost.tsp.lagrangianRelaxation;

import org.chocosolver.graphsolver.cstrs.cost.GraphLagrangianRelaxation;
import org.chocosolver.graphsolver.cstrs.cost.trees.lagrangianRelaxation.PrimMSTFinder;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PrimOneTreeFinder
extends PrimMSTFinder {
    protected int oneNode;

    public PrimOneTreeFinder(int nbNodes, GraphLagrangianRelaxation propagator) {
        super(nbNodes, propagator);
    }

    @Override
    protected void prim() throws ContradictionException {
        this.minVal = this.propHK.getMinArcVal();
        this.chooseOneNode();
        this.inTree.set(this.oneNode);
        ISet nei = this.g.getNeighOf(this.oneNode);
        int min1 = -1;
        int min2 = -1;
        boolean b1 = false;
        boolean b2 = false;
        ISetIterator iSetIterator = nei.iterator();
        while (iSetIterator.hasNext()) {
            int j = (Integer)iSetIterator.next();
            if (!b1) {
                if (min1 == -1) {
                    min1 = j;
                }
                if (this.costs[this.oneNode][j] < this.costs[this.oneNode][min1]) {
                    min2 = min1;
                    min1 = j;
                }
                if (this.propHK.isMandatory(this.oneNode, j)) {
                    if (min1 != j) {
                        min2 = min1;
                    }
                    min1 = j;
                    b1 = true;
                }
            }
            if (min1 == j || b2) continue;
            if (min2 == -1 || this.costs[this.oneNode][j] < this.costs[this.oneNode][min2]) {
                min2 = j;
            }
            if (!this.propHK.isMandatory(this.oneNode, j)) continue;
            min2 = j;
            b2 = true;
        }
        if (min1 == -1 || min2 == -1) {
            this.propHK.contradiction();
        }
        int first = -1;
        int sizeFirst = this.n + 1;
        for (int i = 0; i < this.n; ++i) {
            if (i == this.oneNode || this.g.getNeighOf(i).size() >= sizeFirst) continue;
            first = i;
            sizeFirst = this.g.getNeighOf(i).size();
        }
        if (first == -1) {
            this.propHK.contradiction();
        }
        this.addNode(first);
        while (this.tSize < this.n - 2 && !this.heap.isEmpty()) {
            int to = this.heap.removeFirstElement();
            int from = this.mate[to];
            this.addArc(from, to);
        }
        if (this.tSize != this.n - 2) {
            this.propHK.contradiction();
        }
        this.addArc(this.oneNode, min1);
        this.addArc(this.oneNode, min2);
        if (this.Tree.getNeighOf(this.oneNode).size() != 2) {
            throw new UnsupportedOperationException();
        }
    }

    private void chooseOneNode() {
        this.oneNode = 0;
    }
}

