/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.cost.tsp.lagrangianRelaxation;

import org.chocosolver.graphsolver.cstrs.cost.GraphLagrangianRelaxation;
import org.chocosolver.graphsolver.cstrs.cost.trees.lagrangianRelaxation.KruskalMSTFinder;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class KruskalOneTree_GAC
extends KruskalMSTFinder {
    private int min1;
    private int min2;
    private int[][] map;
    private double[][] marginalCosts;
    private int[] fifo;

    public KruskalOneTree_GAC(int nbNodes, GraphLagrangianRelaxation propagator) {
        super(nbNodes, propagator);
        this.map = new int[this.n][this.n];
        this.marginalCosts = new double[this.n][this.n];
        this.fifo = new int[this.n];
    }

    @Override
    public void computeMST(double[][] costs, UndirectedGraph graph) throws ContradictionException {
        super.computeMST(costs, graph);
        this.add0Node();
    }

    @Override
    public void performPruning(double UB) throws ContradictionException {
        double delta = UB - this.treeCost;
        if (delta < 0.0) {
            throw new UnsupportedOperationException("mst>ub");
        }
        this.prepareMandArcDetection();
        if (this.selectRelevantArcs(delta)) {
            this.lca.preprocess(this.cctRoot, this.ccTree);
            this.pruning(0, delta);
        }
    }

    @Override
    protected void sortArcs() {
        int i;
        int size = 0;
        this.Tree.getNeighOf(0).clear();
        for (int i2 = 1; i2 < this.n; ++i2) {
            this.p[i2] = i2;
            this.rank[i2] = 0;
            this.ccTp[i2] = i2;
            this.Tree.getNeighOf(i2).clear();
            this.ccTree.removeNode(i2);
            this.ccTree.addNode(i2);
            size += this.g.getNeighOf(i2).size();
        }
        assert ((size -= this.g.getNeighOf(0).size()) % 2 == 0);
        size /= 2;
        int idx = 0;
        for (i = 1; i < this.n; ++i) {
            ISet nei = this.g.getNeighOf(i);
            ISetIterator iSetIterator = nei.iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (i >= j) continue;
                this.sortedArcs[idx] = i * this.n + j;
                this.costs[i * this.n + j] = this.distMatrix[i][j];
                ++idx;
            }
        }
        for (i = this.n; i < this.ccN; ++i) {
            this.ccTree.removeNode(i);
        }
        this.sorter.sort(this.sortedArcs, size, this.comparator);
        this.activeArcs.clear();
        this.activeArcs.set(0, size);
        idx = 0;
        while (idx < size) {
            int v = this.sortedArcs[idx];
            this.indexOfArc[v / this.n][v % this.n] = idx++;
        }
    }

    @Override
    protected void pruning(int fi, double delta) throws ContradictionException {
        int j;
        int i;
        ISet nei = this.g.getNeighOf(0);
        ISetIterator iSetIterator = nei.iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            if (i == this.min1 || i == this.min2 || !(this.distMatrix[0][i] - this.distMatrix[0][this.min2] > delta)) continue;
            this.propHK.remove(0, i);
        }
        int arc = this.activeArcs.nextSetBit(0);
        while (arc >= 0) {
            i = this.sortedArcs[arc] / this.n;
            j = this.sortedArcs[arc] % this.n;
            if (!this.Tree.edgeExists(i, j)) {
                this.marginalCosts[i][j] = this.costs[i * this.n + j] - this.ccTEdgeCost[this.lca.getLCA(i, j)];
                if (this.marginalCosts[i][j] > delta) {
                    this.activeArcs.clear(arc);
                    this.propHK.remove(i, j);
                } else {
                    this.markTreeEdges(this.ccTp, i, j);
                }
            }
            arc = this.activeArcs.nextSetBit(arc + 1);
        }
        for (int i2 = 1; i2 < this.n; ++i2) {
            nei = this.Tree.getNeighOf(i2);
            ISetIterator iSetIterator2 = nei.iterator();
            while (iSetIterator2.hasNext()) {
                j = (Integer)iSetIterator2.next();
                if (i2 >= j) continue;
                if (this.map[i2][j] == -1 || this.costs[this.map[i2][j]] - this.costs[i2 * this.n + j] > delta) {
                    this.propHK.enforce(i2, j);
                    continue;
                }
                this.marginalCosts[i2][j] = this.costs[this.map[i2][j]] - this.costs[i2 * this.n + j];
            }
        }
    }

    @Override
    protected boolean selectRelevantArcs(double delta) throws ContradictionException {
        return this.selectAndCompress(delta);
    }

    @Override
    protected boolean selectAndCompress(double delta) throws ContradictionException {
        int idx = this.activeArcs.nextSetBit(0);
        while (idx >= 0 && this.costs[this.sortedArcs[idx]] - this.maxTArc <= delta) {
            idx = this.activeArcs.nextSetBit(idx + 1);
        }
        while (idx >= 0) {
            if (!this.Tree.edgeExists(this.sortedArcs[idx] / this.n, this.sortedArcs[idx] % this.n)) {
                this.propHK.remove(this.sortedArcs[idx] / this.n, this.sortedArcs[idx] % this.n);
                this.activeArcs.clear(idx);
            }
            idx = this.activeArcs.nextSetBit(idx + 1);
        }
        ++this.cctRoot;
        int newNode = this.cctRoot;
        this.ccTree.addNode(newNode);
        this.ccTEdgeCost[newNode] = this.propHK.getMinArcVal();
        ISetIterator iSetIterator = this.ccTree.getNodes().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            if (!this.ccTree.getPredOf(i).isEmpty() || i == this.cctRoot) continue;
            this.ccTree.addArc(this.cctRoot, i);
        }
        return true;
    }

    @Override
    protected int addMandatoryArcs() throws ContradictionException {
        int tSize = 0;
        double val = this.propHK.getMinArcVal();
        for (int i = this.ma.size() - 1; i >= 0; --i) {
            int rTo;
            int arc = this.ma.get(i);
            int from = arc / this.n;
            int to = arc % this.n;
            if (from == 0 || to == 0) continue;
            int rFrom = this.FIND(from);
            if (rFrom != (rTo = this.FIND(to))) {
                this.LINK(rFrom, rTo);
                this.Tree.addEdge(from, to);
                this.updateCCTree(rFrom, rTo, val);
                this.treeCost += this.costs[arc];
                ++tSize;
                continue;
            }
            this.propHK.contradiction();
        }
        return tSize;
    }

    @Override
    protected void connectMST(int treeSize) throws ContradictionException {
        int idx = this.activeArcs.nextSetBit(0);
        this.minTArc = -this.propHK.getMinArcVal();
        this.maxTArc = this.propHK.getMinArcVal();
        int tSize = treeSize;
        while (tSize < this.n - 2) {
            int rTo;
            if (idx < 0) {
                this.propHK.contradiction();
            }
            int from = this.sortedArcs[idx] / this.n;
            int to = this.sortedArcs[idx] % this.n;
            int rFrom = this.FIND(from);
            if (rFrom != (rTo = this.FIND(to))) {
                this.LINK(rFrom, rTo);
                this.Tree.addEdge(from, to);
                double cost = this.costs[this.sortedArcs[idx]];
                this.updateCCTree(rFrom, rTo, cost);
                if (cost > this.maxTArc) {
                    this.maxTArc = cost;
                }
                if (cost < this.minTArc) {
                    this.minTArc = cost;
                }
                this.treeCost += cost;
                ++tSize;
            }
            idx = this.activeArcs.nextSetBit(idx + 1);
        }
    }

    private void add0Node() throws ContradictionException {
        ISet nei = this.g.getNeighOf(0);
        this.min1 = -1;
        this.min2 = -1;
        boolean b1 = false;
        boolean b2 = false;
        ISetIterator iSetIterator = nei.iterator();
        while (iSetIterator.hasNext()) {
            int j = (Integer)iSetIterator.next();
            if (!b1) {
                if (this.min1 == -1) {
                    this.min1 = j;
                }
                if (this.distMatrix[0][j] < this.distMatrix[0][this.min1]) {
                    this.min2 = this.min1;
                    this.min1 = j;
                }
                if (this.propHK.isMandatory(0, j)) {
                    if (this.min1 != j) {
                        this.min2 = this.min1;
                    }
                    this.min1 = j;
                    b1 = true;
                }
            }
            if (this.min1 == j || b2) continue;
            if (this.min2 == -1 || this.distMatrix[0][j] < this.distMatrix[0][this.min2]) {
                this.min2 = j;
            }
            if (!this.propHK.isMandatory(0, j)) continue;
            this.min2 = j;
            b2 = true;
        }
        if (this.min1 == this.min2) {
            throw new UnsupportedOperationException();
        }
        if (this.min1 == -1 || this.min2 == -1) {
            this.propHK.contradiction();
        }
        if (!this.propHK.isMandatory(0, this.min1)) {
            this.maxTArc = Math.max(this.maxTArc, this.distMatrix[0][this.min1]);
        }
        if (!this.propHK.isMandatory(0, this.min2)) {
            this.maxTArc = Math.max(this.maxTArc, this.distMatrix[0][this.min2]);
        }
        this.Tree.addEdge(0, this.min1);
        this.Tree.addEdge(0, this.min2);
        this.treeCost += this.distMatrix[0][this.min1] + this.distMatrix[0][this.min2];
    }

    protected void prepareMandArcDetection() {
        int first;
        for (int i = 0; i < this.n; ++i) {
            this.ccTp[i] = -1;
        }
        this.useful.clear();
        this.useful.set(0);
        int k = 1;
        this.useful.set(k);
        this.ccTp[k] = k;
        int last = first = 0;
        this.fifo[last++] = k;
        while (first < last) {
            k = this.fifo[first++];
            ISet nei = this.Tree.getNeighOf(k);
            ISetIterator iSetIterator = nei.iterator();
            while (iSetIterator.hasNext()) {
                int s = (Integer)iSetIterator.next();
                if (this.ccTp[s] != -1) continue;
                this.ccTp[s] = k;
                this.map[k][s] = -1;
                this.map[s][k] = -1;
                if (this.useful.get(s)) continue;
                this.fifo[last++] = s;
                this.useful.set(s);
            }
        }
    }

    protected void markTreeEdges(int[] next, int i, int j) {
        int tmp;
        int rep = i * this.n + j;
        if (i == 0) {
            throw new UnsupportedOperationException();
        }
        if (next[i] == next[j]) {
            if (this.map[i][next[i]] == -1) {
                int n = rep;
                this.map[next[i]][i] = n;
                this.map[i][next[i]] = n;
            }
            if (this.map[j][next[j]] == -1) {
                int n = rep;
                this.map[next[j]][j] = n;
                this.map[j][next[j]] = n;
            }
            return;
        }
        this.useful.clear();
        int meeting = j;
        int a = i;
        while (a != next[a]) {
            this.useful.set(a);
            a = next[a];
        }
        this.useful.set(a);
        while (!this.useful.get(meeting)) {
            meeting = next[meeting];
        }
        int b = j;
        while (b != meeting) {
            tmp = next[b];
            next[b] = meeting;
            if (this.map[b][tmp] == -1) {
                int n = rep;
                this.map[tmp][b] = n;
                this.map[b][tmp] = n;
            }
            b = tmp;
        }
        a = i;
        while (a != meeting) {
            tmp = next[a];
            next[a] = meeting;
            if (this.map[a][tmp] == -1) {
                int n = rep;
                this.map[tmp][a] = n;
                this.map[a][tmp] = n;
            }
            a = tmp;
        }
    }

    @Override
    public double getRepCost(int from, int to) {
        if (from > to) {
            return this.getRepCost(to, from);
        }
        if (from == 0) {
            return 0.0;
        }
        return this.marginalCosts[from][to];
    }
}

