/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.cost.tsp.heap;

import org.chocosolver.graphsolver.cstrs.cost.tsp.heap.ArrayHeap;

public class FastArrayHeap
extends ArrayHeap {
    private int[] best;
    private int bestSize;
    private double bestVal;

    public FastArrayHeap(int n) {
        super(n);
        this.best = new int[n];
    }

    @Override
    public boolean addOrUpdateElement(int element, double element_key) {
        if (this.isEmpty() || element_key < this.bestVal) {
            this.bestVal = element_key;
            this.bestSize = 0;
            this.best[this.bestSize++] = element;
        } else if (element_key == this.bestVal && element_key < this.value[element]) {
            this.best[this.bestSize++] = element;
        }
        return super.addOrUpdateElement(element, element_key);
    }

    @Override
    public int removeFirstElement() {
        if (this.bestSize > 0) {
            int min = this.best[--this.bestSize];
            this.in.clear(min);
            --this.size;
            return min;
        }
        return super.removeFirstElement();
    }

    @Override
    public void clear() {
        super.clear();
        this.bestSize = 0;
    }
}

