/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.cost.tsp.heap;

import java.util.BitSet;
import org.chocosolver.graphsolver.cstrs.cost.tsp.heap.ISimpleHeap;

public class ArrayHeap
implements ISimpleHeap {
    protected BitSet in;
    protected double[] value;
    protected int size;

    public ArrayHeap(int n) {
        this.in = new BitSet(n);
        this.value = new double[n];
        this.size = 0;
    }

    @Override
    public boolean addOrUpdateElement(int element, double element_key) {
        if (!this.in.get(element)) {
            this.in.set(element);
            ++this.size;
            this.value[element] = element_key;
            return true;
        }
        if (element_key < this.value[element]) {
            this.value[element] = element_key;
            return true;
        }
        return false;
    }

    @Override
    public int removeFirstElement() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        int min = this.in.nextSetBit(0);
        int i = this.in.nextSetBit(0);
        while (i >= 0) {
            if (this.value[i] < this.value[min]) {
                min = i;
            }
            i = this.in.nextSetBit(i + 1);
        }
        this.in.clear(min);
        --this.size;
        return min;
    }

    @Override
    public void clear() {
        this.in.clear();
        this.size = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }
}

