/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.cost.trees.lagrangianRelaxation;

import gnu.trove.list.array.TIntArrayList;
import org.chocosolver.graphsolver.cstrs.cost.GraphLagrangianRelaxation;
import org.chocosolver.graphsolver.cstrs.cost.trees.lagrangianRelaxation.AbstractTreeFinder;
import org.chocosolver.graphsolver.cstrs.cost.trees.lagrangianRelaxation.KruskalMST_GAC;
import org.chocosolver.graphsolver.cstrs.cost.trees.lagrangianRelaxation.PrimMSTFinder;
import org.chocosolver.graphsolver.variables.UndirectedGraphVar;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class PropLagr_DCMST_generic
extends Propagator<Variable>
implements GraphLagrangianRelaxation {
    protected UndirectedGraphVar gV;
    protected UndirectedGraph g;
    protected IntVar obj;
    protected int n;
    protected int[][] originalCosts;
    protected double[][] costs;
    protected UndirectedGraph mst;
    protected TIntArrayList mandatoryArcsList;
    protected AbstractTreeFinder HKfilter;
    protected AbstractTreeFinder HK;
    protected long nbRem;
    protected boolean waitFirstSol;
    protected int nbSprints;
    protected IntVar[] D;
    protected int[] Dmax;
    protected int[] Dmin;
    protected double[] lambdaMin;
    protected double[] lambdaMax;
    protected double C;
    protected double K;
    protected boolean firstPropag = true;
    protected long nbSols = 0L;
    protected int objUB = -1;

    public PropLagr_DCMST_generic(UndirectedGraphVar graph, IntVar cost, IntVar[] degrees, int[][] costMatrix, boolean waitFirstSol) {
        super(new Variable[]{graph, cost}, PropagatorPriority.CUBIC, false);
        this.gV = graph;
        this.n = this.gV.getNbMaxNodes();
        this.obj = cost;
        this.originalCosts = costMatrix;
        this.costs = new double[this.n][this.n];
        this.lambdaMin = new double[this.n];
        this.lambdaMax = new double[this.n];
        this.mandatoryArcsList = new TIntArrayList();
        this.nbRem = 0L;
        this.nbSprints = 30;
        this.D = degrees;
        this.Dmin = new int[this.n];
        this.Dmax = new int[this.n];
        this.HK = new PrimMSTFinder(this.n, this);
        this.HKfilter = new KruskalMST_GAC(this.n, this);
        this.waitFirstSol = waitFirstSol;
        this.g = new UndirectedGraph(this.n, SetType.BITSET, true);
        for (int i = 0; i < this.n; ++i) {
            for (int j = i + 1; j < this.n; ++j) {
                this.g.addEdge(i, j);
            }
        }
    }

    protected void lagrangianRelaxation() throws ContradictionException {
        int lb = this.obj.getLB();
        this.nbSprints = 30;
        if (this.nbSols != this.model.getSolver().getSolutionCount() || this.obj.getUB() < this.objUB || this.firstPropag && !this.waitFirstSol) {
            this.nbSols = this.model.getSolver().getSolutionCount();
            this.objUB = this.obj.getUB();
            this.convergeAndFilter();
            this.firstPropag = false;
            this.g = (UndirectedGraph)this.gV.getUB();
        } else {
            this.fastRun(2.0);
        }
        if (lb < this.obj.getLB()) {
            this.lagrangianRelaxation();
        }
    }

    protected void fastRun(double coef) throws ContradictionException {
        this.convergeFast(coef);
        this.HKfilter.computeMST(this.costs, this.g);
        double hkb = this.HKfilter.getBound() - this.C;
        this.mst = this.HKfilter.getMST();
        if (hkb - Math.floor(hkb) < 0.001) {
            hkb = Math.floor(hkb);
        }
        this.obj.updateLowerBound((int)Math.ceil(hkb), (ICause)this);
        this.HKfilter.performPruning((double)this.obj.getUB() + this.C + 0.001);
    }

    protected void convergeAndFilter() throws ContradictionException {
        double beta = 0.5;
        double besthkb = -9999998.0;
        double oldhkb = -9999999.0;
        for (double alpha = 2.0; oldhkb + 0.001 < besthkb || alpha > 0.01; alpha *= beta) {
            oldhkb = besthkb;
            this.convergeFast(alpha);
            this.HKfilter.computeMST(this.costs, this.g);
            double hkb = this.HKfilter.getBound() - this.C;
            if (hkb > besthkb) {
                besthkb = hkb;
            }
            this.mst = this.HKfilter.getMST();
            if (hkb - Math.floor(hkb) < 1.0E-5) {
                hkb = Math.floor(hkb);
            }
            this.obj.updateLowerBound((int)Math.ceil(hkb), (ICause)this);
            this.HKfilter.performPruning((double)this.obj.getUB() + this.C + 0.001);
        }
    }

    protected void convergeFast(double alpha) throws ContradictionException {
        double besthkb = 0.0;
        double oldhkb = -20.0;
        while (oldhkb + 0.1 < besthkb) {
            oldhkb = besthkb;
            for (int i = 0; i < this.nbSprints; ++i) {
                this.HK.computeMST(this.costs, this.g);
                this.mst = this.HK.getMST();
                double hkb = this.HK.getBound() - this.C;
                if (hkb - Math.floor(hkb) < 0.001) {
                    hkb = Math.floor(hkb);
                }
                if (hkb > besthkb) {
                    besthkb = hkb;
                }
                this.obj.updateLowerBound((int)Math.ceil(hkb), (ICause)this);
                if (!this.updateStep(hkb, alpha)) continue;
                return;
            }
        }
    }

    protected boolean updateStep(double hkb, double alpha) {
        int deg;
        double nb2viol = 0.0;
        double target = this.obj.getUB();
        assert (target - hkb >= 0.0);
        if (target - hkb < 0.001) {
            target = hkb + 0.001;
        }
        for (int i = 0; i < this.n; ++i) {
            deg = this.mst.getNeighOf(i).size();
            if (deg > this.Dmax[i] || this.lambdaMax[i] != 0.0) {
                nb2viol += (double)((this.Dmax[i] - deg) * (this.Dmax[i] - deg));
            }
            if (deg >= this.Dmin[i] && this.lambdaMin[i] == 0.0) continue;
            nb2viol += (double)((this.Dmin[i] - deg) * (this.Dmin[i] - deg));
        }
        if (nb2viol == 0.0) {
            return true;
        }
        this.K = alpha * (target - hkb) / nb2viol;
        if (this.K < 1.0E-4) {
            return true;
        }
        double maxPen = 2 * this.obj.getUB();
        for (int i = 0; i < this.n; ++i) {
            deg = this.mst.getNeighOf(i).size();
            int n = i;
            this.lambdaMin[n] = this.lambdaMin[n] + (double)(deg - this.Dmin[i]) * this.K;
            int n2 = i;
            this.lambdaMax[n2] = this.lambdaMax[n2] + (double)(deg - this.Dmax[i]) * this.K;
            if (this.lambdaMin[i] > 0.0) {
                this.lambdaMin[i] = 0.0;
            }
            this.lambdaMin[i] = 0.0;
            if (this.lambdaMax[i] < 0.0) {
                this.lambdaMax[i] = 0.0;
            }
            if (this.gV.getPotNeighOf(i).size() <= this.Dmax[i]) {
                this.lambdaMax[i] = 0.0;
            }
            if (this.gV.getMandNeighOf(i).size() >= this.Dmin[i] || this.Dmin[i] <= 1) {
                this.lambdaMin[i] = 0.0;
            }
            if (this.lambdaMin[i] < -maxPen) {
                this.lambdaMin[i] = -maxPen;
            }
            if (this.lambdaMax[i] > maxPen) {
                this.lambdaMax[i] = maxPen;
            }
            assert (!(this.lambdaMax[i] > Double.MAX_VALUE / (double)(this.n - 1)) && !(this.lambdaMax[i] < 0.0));
            assert (!(this.lambdaMin[i] < -1.7976931348623157E308 / (double)(this.n - 1)) && !(this.lambdaMin[i] > 0.0));
        }
        this.updateCosts();
        return false;
    }

    protected void updateCosts() {
        this.C = 0.0;
        for (int i = 0; i < this.n; ++i) {
            this.C += (double)this.Dmax[i] * this.lambdaMax[i];
            this.C += (double)this.Dmin[i] * this.lambdaMin[i];
            ISet nei = this.g.getNeighOf(i);
            ISetIterator iSetIterator = nei.iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (i >= j) continue;
                double d = (double)this.originalCosts[i][j] + this.lambdaMin[i] + this.lambdaMin[j] + this.lambdaMax[i] + this.lambdaMax[j];
                this.costs[i][j] = d;
                this.costs[j][i] = d;
                assert (this.costs[j][i] >= 0.0);
            }
        }
        assert (this.C > -1.7976931348623157E308 / (double)(this.n - 1) && this.C < Double.MAX_VALUE / (double)(this.n - 1));
    }

    @Override
    public void remove(int from, int to) throws ContradictionException {
        this.gV.removeArc(from, to, (ICause)this);
        if (this.firstPropag) {
            this.g.removeEdge(from, to);
        }
        ++this.nbRem;
    }

    @Override
    public void enforce(int from, int to) throws ContradictionException {
        this.gV.enforceArc(from, to, (ICause)this);
    }

    @Override
    public void contradiction() throws ContradictionException {
        this.fails();
    }

    public void propagate(int evtmask) throws ContradictionException {
        int i;
        if (this.waitFirstSol && this.model.getSolver().getSolutionCount() == 0L) {
            return;
        }
        this.mandatoryArcsList.clear();
        for (i = 0; i < this.n; ++i) {
            this.Dmin[i] = this.D[i].getLB();
            this.Dmax[i] = this.D[i].getUB();
        }
        for (i = 0; i < this.n; ++i) {
            ISet nei = this.gV.getMandNeighOf(i);
            ISetIterator iSetIterator = nei.iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (i >= j) continue;
                this.mandatoryArcsList.add(i * this.n + j);
            }
        }
        this.updateCosts();
        this.lagrangianRelaxation();
    }

    public ESat isEntailed() {
        return ESat.TRUE;
    }

    @Override
    public double getMinArcVal() {
        return -2.14748364E8;
    }

    @Override
    public TIntArrayList getMandatoryArcsList() {
        return this.mandatoryArcsList;
    }

    @Override
    public boolean isMandatory(int i, int j) {
        return this.gV.getMandNeighOf(i).contains(j);
    }

    @Override
    public void waitFirstSolution(boolean b) {
        this.waitFirstSol = b;
    }

    @Override
    public boolean contains(int i, int j) {
        return this.mst == null || this.mst.edgeExists(i, j);
    }

    public UndirectedGraph getSupport() {
        return this.mst;
    }

    @Override
    public double getReplacementCost(int from, int to) {
        return this.HKfilter.getRepCost(from, to);
    }

    @Override
    public double getMarginalCost(int from, int to) {
        return this.HKfilter.getRepCost(from, to);
    }
}

