/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.cost.trees.lagrangianRelaxation;

import gnu.trove.list.array.TIntArrayList;
import org.chocosolver.graphsolver.cstrs.cost.GraphLagrangianRelaxation;
import org.chocosolver.graphsolver.cstrs.cost.trees.lagrangianRelaxation.AbstractTreeFinder;
import org.chocosolver.graphsolver.cstrs.cost.trees.lagrangianRelaxation.KruskalMST_GAC;
import org.chocosolver.graphsolver.cstrs.cost.trees.lagrangianRelaxation.PrimMSTFinder;
import org.chocosolver.graphsolver.variables.GraphEventType;
import org.chocosolver.graphsolver.variables.UndirectedGraphVar;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class PropLagr_DCMST
extends Propagator<Variable>
implements GraphLagrangianRelaxation {
    protected UndirectedGraphVar gV;
    protected UndirectedGraph g;
    protected IntVar obj;
    protected int n;
    protected int[][] originalCosts;
    protected double[][] costs;
    protected double[] penalities;
    protected double totalPenalities;
    protected UndirectedGraph mst;
    protected TIntArrayList mandatoryArcsList;
    protected AbstractTreeFinder HKfilter;
    protected AbstractTreeFinder HK;
    protected long nbRem;
    protected boolean waitFirstSol;
    protected int nbSprints;
    protected int[] maxDegree;
    protected double step;
    protected boolean firstPropag = true;
    private long nbSols = 0L;
    private int objUB = -1;

    public PropLagr_DCMST(UndirectedGraphVar graph, IntVar cost, int[] maxDegree, int[][] costMatrix, boolean waitFirstSol) {
        super(new Variable[]{graph, cost}, PropagatorPriority.CUBIC, false);
        this.gV = graph;
        this.n = this.gV.getNbMaxNodes();
        this.obj = cost;
        this.originalCosts = costMatrix;
        this.costs = new double[this.n][this.n];
        this.penalities = new double[this.n];
        this.totalPenalities = 0.0;
        this.mandatoryArcsList = new TIntArrayList();
        this.nbRem = 0L;
        this.nbSprints = 30;
        this.maxDegree = maxDegree;
        this.HK = new PrimMSTFinder(this.n, this);
        this.HKfilter = new KruskalMST_GAC(this.n, this);
        this.waitFirstSol = waitFirstSol;
        this.g = new UndirectedGraph(this.n, SetType.BITSET, true);
        for (int i = 0; i < this.n; ++i) {
            for (int j = i + 1; j < this.n; ++j) {
                this.g.addEdge(i, j);
            }
        }
    }

    protected void lagrangianRelaxation() throws ContradictionException {
        int lb = this.obj.getLB();
        this.nbSprints = 30;
        if (this.nbSols != this.model.getSolver().getSolutionCount() || this.obj.getUB() < this.objUB || this.firstPropag && !this.waitFirstSol) {
            this.nbSols = this.model.getSolver().getSolutionCount();
            this.objUB = this.obj.getUB();
            this.convergeAndFilter();
            this.firstPropag = false;
            this.g = (UndirectedGraph)this.gV.getUB();
        } else {
            this.fastRun(2.0);
        }
        if (lb < this.obj.getLB()) {
            this.lagrangianRelaxation();
        }
    }

    protected void fastRun(double coef) throws ContradictionException {
        this.convergeFast(coef);
        this.HKfilter.computeMST(this.costs, this.g);
        double hkb = this.HKfilter.getBound() - this.totalPenalities;
        this.mst = this.HKfilter.getMST();
        if (hkb - Math.floor(hkb) < 0.001) {
            hkb = Math.floor(hkb);
        }
        this.obj.updateLowerBound((int)Math.ceil(hkb), (ICause)this);
        this.HKfilter.performPruning((double)this.obj.getUB() + this.totalPenalities + 0.001);
    }

    protected void convergeAndFilter() throws ContradictionException {
        double beta = 0.5;
        double besthkb = -9999998.0;
        double oldhkb = -9999999.0;
        for (double alpha = 2.0; oldhkb + 0.001 < besthkb || alpha > 0.01; alpha *= beta) {
            oldhkb = besthkb;
            this.convergeFast(alpha);
            this.HKfilter.computeMST(this.costs, this.g);
            double hkb = this.HKfilter.getBound() - this.totalPenalities;
            if (hkb > besthkb) {
                besthkb = hkb;
            }
            this.mst = this.HKfilter.getMST();
            if (hkb - Math.floor(hkb) < 1.0E-5) {
                hkb = Math.floor(hkb);
            }
            this.obj.updateLowerBound((int)Math.ceil(hkb), (ICause)this);
            this.HKfilter.performPruning((double)this.obj.getUB() + this.totalPenalities + 0.001);
        }
    }

    protected void convergeFast(double alpha) throws ContradictionException {
        double besthkb = 0.0;
        double oldhkb = -20.0;
        while (oldhkb + 0.1 < besthkb) {
            oldhkb = besthkb;
            for (int i = 0; i < this.nbSprints; ++i) {
                this.HK.computeMST(this.costs, this.g);
                this.mst = this.HK.getMST();
                double hkb = this.HK.getBound() - this.totalPenalities;
                if (hkb - Math.floor(hkb) < 0.001) {
                    hkb = Math.floor(hkb);
                }
                if (hkb > besthkb) {
                    besthkb = hkb;
                }
                this.obj.updateLowerBound((int)Math.ceil(hkb), (ICause)this);
                if (!this.updateStep(hkb, alpha)) continue;
                return;
            }
        }
    }

    protected boolean updateStep(double hkb, double alpha) {
        int deg;
        double nb2viol = 0.0;
        double target = this.obj.getUB();
        assert (target - hkb >= 0.0);
        if (target - hkb < 0.001) {
            target = hkb + 0.001;
        }
        for (int i = 0; i < this.n; ++i) {
            deg = this.mst.getNeighOf(i).size();
            if (deg <= this.maxDegree[i] && !(this.penalities[i] > 0.0)) continue;
            nb2viol += (double)((this.maxDegree[i] - deg) * (this.maxDegree[i] - deg));
        }
        if (nb2viol == 0.0) {
            return true;
        }
        this.step = alpha * (target - hkb) / nb2viol;
        if (this.step < 1.0E-4) {
            return true;
        }
        double maxPen = 2 * this.obj.getUB();
        this.totalPenalities = 0.0;
        for (int i = 0; i < this.n; ++i) {
            deg = this.mst.getNeighOf(i).size();
            int n = i;
            this.penalities[n] = this.penalities[n] + (double)(deg - this.maxDegree[i]) * this.step;
            if (this.penalities[i] < 0.0 || this.g.getNeighOf(i).size() <= this.maxDegree[i]) {
                this.penalities[i] = 0.0;
            }
            if (this.penalities[i] > maxPen) {
                this.penalities[i] = maxPen;
            }
            assert (!(this.penalities[i] > Double.MAX_VALUE / (double)(this.n - 1)) && !(this.penalities[i] < 0.0));
            this.totalPenalities += this.penalities[i] * (double)this.maxDegree[i];
        }
        assert (!(this.totalPenalities > Double.MAX_VALUE / (double)(this.n - 1)) && !(this.totalPenalities < 0.0));
        for (int i = 0; i < this.n; ++i) {
            ISet nei = this.g.getNeighOf(i);
            ISetIterator iSetIterator = nei.iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (i >= j) continue;
                double d = (double)this.originalCosts[i][j] + this.penalities[i] + this.penalities[j];
                this.costs[i][j] = d;
                this.costs[j][i] = d;
            }
        }
        return false;
    }

    @Override
    public void remove(int from, int to) throws ContradictionException {
        this.gV.removeArc(from, to, (ICause)this);
        if (this.firstPropag) {
            this.g.removeEdge(from, to);
        }
        ++this.nbRem;
    }

    @Override
    public void enforce(int from, int to) throws ContradictionException {
        this.gV.enforceArc(from, to, (ICause)this);
    }

    @Override
    public void contradiction() throws ContradictionException {
        this.fails();
    }

    public void propagate(int evtmask) throws ContradictionException {
        if (this.waitFirstSol && this.model.getSolver().getSolutionCount() == 0L) {
            return;
        }
        this.mandatoryArcsList.clear();
        this.totalPenalities = 0.0;
        for (int i = 0; i < this.n; ++i) {
            int j;
            this.totalPenalities += this.penalities[i] * (double)this.maxDegree[i];
            ISet nei = this.gV.getMandNeighOf(i);
            ISetIterator iSetIterator = nei.iterator();
            while (iSetIterator.hasNext()) {
                j = (Integer)iSetIterator.next();
                if (i >= j) continue;
                this.mandatoryArcsList.add(i * this.n + j);
            }
            nei = this.g.getNeighOf(i);
            iSetIterator = nei.iterator();
            while (iSetIterator.hasNext()) {
                j = (Integer)iSetIterator.next();
                if (i >= j) continue;
                double d = (double)this.originalCosts[i][j] + this.penalities[i] + this.penalities[j];
                this.costs[i][j] = d;
                this.costs[j][i] = d;
                if (!(this.costs[i][j] < 0.0)) continue;
                throw new UnsupportedOperationException();
            }
        }
        this.lagrangianRelaxation();
    }

    public int getPropagationConditions(int vIdx) {
        if (vIdx == 0) {
            return GraphEventType.REMOVE_ARC.getMask() + GraphEventType.ADD_ARC.getMask();
        }
        return IntEventType.boundAndInst();
    }

    public ESat isEntailed() {
        return ESat.TRUE;
    }

    @Override
    public double getMinArcVal() {
        return -1.0;
    }

    @Override
    public TIntArrayList getMandatoryArcsList() {
        return this.mandatoryArcsList;
    }

    @Override
    public boolean isMandatory(int i, int j) {
        return this.gV.getMandNeighOf(i).contains(j);
    }

    @Override
    public void waitFirstSolution(boolean b) {
        this.waitFirstSol = b;
    }

    @Override
    public boolean contains(int i, int j) {
        return this.mst == null || this.mst.edgeExists(i, j);
    }

    public UndirectedGraph getSupport() {
        return this.mst;
    }

    @Override
    public double getReplacementCost(int from, int to) {
        return this.HKfilter.getRepCost(from, to);
    }

    @Override
    public double getMarginalCost(int from, int to) {
        return this.HKfilter.getRepCost(from, to);
    }
}

