/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.cost.trees.lagrangianRelaxation;

import java.util.BitSet;
import org.chocosolver.graphsolver.cstrs.cost.GraphLagrangianRelaxation;
import org.chocosolver.graphsolver.cstrs.cost.trees.lagrangianRelaxation.AbstractTreeFinder;
import org.chocosolver.graphsolver.cstrs.cost.tsp.heap.FastSimpleHeap;
import org.chocosolver.graphsolver.cstrs.cost.tsp.heap.ISimpleHeap;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PrimMSTFinder
extends AbstractTreeFinder {
    protected double[][] costs;
    protected ISimpleHeap heap;
    protected BitSet inTree;
    protected int[] mate;
    protected int tSize;
    protected double minVal;
    protected double maxTArc;

    public PrimMSTFinder(int nbNodes, GraphLagrangianRelaxation propagator) {
        super(nbNodes, propagator);
        this.heap = new FastSimpleHeap(nbNodes);
        this.inTree = new BitSet(this.n);
        this.mate = new int[this.n];
    }

    @Override
    public void computeMST(double[][] costs, UndirectedGraph graph) throws ContradictionException {
        this.g = graph;
        for (int i = 0; i < this.n; ++i) {
            this.Tree.getNeighOf(i).clear();
        }
        this.costs = costs;
        this.heap.clear();
        this.inTree.clear();
        this.treeCost = 0.0;
        this.tSize = 0;
        this.prim();
    }

    protected void prim() throws ContradictionException {
        this.minVal = this.propHK.getMinArcVal();
        this.addNode(0);
        while (this.tSize < this.n - 1 && !this.heap.isEmpty()) {
            int to = this.heap.removeFirstElement();
            int from = this.mate[to];
            this.addArc(from, to);
        }
        if (this.tSize != this.n - 1) {
            this.propHK.contradiction();
        }
    }

    protected void addArc(int from, int to) {
        if (this.Tree.edgeExists(from, to)) {
            throw new UnsupportedOperationException();
        }
        this.Tree.addEdge(from, to);
        this.treeCost += this.costs[from][to];
        ++this.tSize;
        this.addNode(to);
    }

    protected void addNode(int i) {
        if (!this.inTree.get(i)) {
            this.inTree.set(i);
            ISet nei = this.g.getNeighOf(i);
            ISetIterator iSetIterator = nei.iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (this.inTree.get(j)) continue;
                if (this.propHK.isMandatory(i, j)) {
                    this.heap.addOrUpdateElement(j, -2.147483648E9);
                    this.mate[j] = i;
                    continue;
                }
                if (!this.heap.addOrUpdateElement(j, this.costs[i][j])) continue;
                this.mate[j] = i;
            }
        }
    }

    @Override
    public void performPruning(double UB) throws ContradictionException {
        throw new UnsupportedOperationException("bound computation only, no filtering!");
    }
}

