/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.cost.trees;

import java.util.BitSet;
import org.chocosolver.graphsolver.variables.GraphEventType;
import org.chocosolver.graphsolver.variables.UndirectedGraphVar;
import org.chocosolver.graphsolver.variables.delta.GraphDeltaMonitor;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.PairProcedure;

public class PropTreeNoSubtour
extends Propagator<UndirectedGraphVar> {
    private UndirectedGraphVar g;
    private GraphDeltaMonitor gdm;
    private int n;
    private PairProcedure arcEnforced;
    private IStateInt[] color;
    private IStateInt[] size;
    private int[] fifo;
    private int[] mate;
    private BitSet in;

    public PropTreeNoSubtour(UndirectedGraphVar graph) {
        super((Variable[])new UndirectedGraphVar[]{graph}, PropagatorPriority.LINEAR, true);
        this.g = graph;
        this.gdm = this.g.monitorDelta((ICause)this);
        this.n = this.g.getNbMaxNodes();
        this.arcEnforced = new EnfArc();
        this.fifo = new int[this.n];
        this.mate = new int[this.n];
        this.in = new BitSet(this.n);
        this.color = new IStateInt[this.n];
        this.size = new IStateInt[this.n];
        IEnvironment environment = graph.getEnvironment();
        for (int i = 0; i < this.n; ++i) {
            this.color[i] = environment.makeInt(i);
            this.size[i] = environment.makeInt(1);
        }
    }

    public void propagate(int evtmask) throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            this.color[i].set(i);
            this.size[i].set(1);
            this.mate[i] = -1;
        }
        for (int i = 0; i < this.n; ++i) {
            ISet nei = this.g.getMandNeighOf(i);
            ISetIterator iSetIterator = nei.iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (i >= j) continue;
                this.enforce(i, j);
            }
        }
        this.gdm.unfreeze();
    }

    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.gdm.freeze();
        this.gdm.forEachArc(this.arcEnforced, GraphEventType.ADD_ARC);
        this.gdm.unfreeze();
    }

    public int getPropagationConditions(int vIdx) {
        return GraphEventType.ADD_ARC.getMask();
    }

    public ESat isEntailed() {
        return ESat.TRUE;
    }

    private void enforce(int i, int j) throws ContradictionException {
        int cj;
        if (this.size[this.color[i].get()].get() > this.size[this.color[j].get()].get()) {
            this.enforce(j, i);
            return;
        }
        if (i == j) {
            throw new UnsupportedOperationException();
        }
        int ci = this.color[i].get();
        if (ci == (cj = this.color[j].get())) {
            this.fails();
        }
        int idxFirst = 0;
        int idxLast = 0;
        this.in.clear();
        this.in.set(i);
        this.fifo[idxLast++] = i;
        this.mate[i] = j;
        while (idxFirst < idxLast) {
            int x = this.fifo[idxFirst++];
            ISetIterator iSetIterator = this.g.getPotNeighOf(x).iterator();
            while (iSetIterator.hasNext()) {
                int k = (Integer)iSetIterator.next();
                if (k == this.mate[x]) continue;
                int ck = this.color[k].get();
                if (ck == cj) {
                    this.g.removeArc(x, k, (ICause)this);
                    continue;
                }
                if (ck != ci || this.in.get(k)) continue;
                this.in.set(k);
                this.fifo[idxLast++] = k;
                this.mate[k] = x;
            }
            this.color[x].set(cj);
        }
        this.size[cj].add(this.size[ci].get());
    }

    private class EnfArc
    implements PairProcedure {
        private EnfArc() {
        }

        public void execute(int i, int j) throws ContradictionException {
            PropTreeNoSubtour.this.enforce(i, j);
        }
    }
}

