/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.cost.trees;

import org.chocosolver.graphsolver.variables.GraphEventType;
import org.chocosolver.graphsolver.variables.UndirectedGraphVar;
import org.chocosolver.graphsolver.variables.delta.GraphDeltaMonitor;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.PairProcedure;

public class PropTreeCostSimple
extends Propagator<UndirectedGraphVar> {
    protected UndirectedGraphVar g;
    private GraphDeltaMonitor gdm;
    private PairProcedure edgeEnf;
    private PairProcedure edgeRem;
    protected int n;
    protected IntVar sum;
    protected int[][] distMatrix;
    private IStateInt minSum;
    private IStateInt maxSum;

    public PropTreeCostSimple(UndirectedGraphVar graph, IntVar obj, int[][] costMatrix) {
        super((Variable[])new UndirectedGraphVar[]{graph}, PropagatorPriority.LINEAR, true);
        this.g = graph;
        this.sum = obj;
        this.n = this.g.getNbMaxNodes();
        this.distMatrix = costMatrix;
        IEnvironment environment = graph.getEnvironment();
        this.minSum = environment.makeInt(0);
        this.maxSum = environment.makeInt(0);
        this.gdm = this.g.monitorDelta((ICause)this);
        this.edgeEnf = (i, j) -> this.minSum.add(this.distMatrix[i][j]);
        this.edgeRem = (i, j) -> this.maxSum.add(-this.distMatrix[i][j]);
    }

    public void propagate(int evtmask) throws ContradictionException {
        int min = 0;
        int max = 0;
        for (int i = 0; i < this.n; ++i) {
            ISet nei = this.g.getPotNeighOf(i);
            ISetIterator iSetIterator = nei.iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (i > j) continue;
                max += this.distMatrix[i][j];
                if (!this.g.getMandNeighOf(i).contains(j)) continue;
                min += this.distMatrix[i][j];
            }
        }
        this.gdm.unfreeze();
        this.minSum.set(min);
        this.maxSum.set(max);
        this.sum.updateLowerBound(min, (ICause)this);
        this.sum.updateUpperBound(max, (ICause)this);
    }

    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.gdm.freeze();
        this.gdm.forEachArc(this.edgeEnf, GraphEventType.ADD_ARC);
        this.gdm.forEachArc(this.edgeRem, GraphEventType.REMOVE_ARC);
        this.gdm.unfreeze();
        this.sum.updateLowerBound(this.minSum.get(), (ICause)this);
        this.sum.updateUpperBound(this.maxSum.get(), (ICause)this);
    }

    public int getPropagationConditions(int vIdx) {
        return GraphEventType.REMOVE_ARC.getMask() + GraphEventType.ADD_ARC.getMask();
    }

    public ESat isEntailed() {
        int min = 0;
        int max = 0;
        for (int i = 0; i < this.n; ++i) {
            ISet nei = this.g.getPotNeighOf(i);
            ISetIterator iSetIterator = nei.iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (i > j) continue;
                max += this.distMatrix[i][j];
                if (!this.g.getMandNeighOf(i).contains(j)) continue;
                min += this.distMatrix[i][j];
            }
        }
        if (min > this.sum.getUB() || max < this.sum.getLB()) {
            return ESat.FALSE;
        }
        if (min == max) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

