/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.cost.trees;

import java.util.BitSet;
import org.chocosolver.graphsolver.variables.GraphEventType;
import org.chocosolver.graphsolver.variables.UndirectedGraphVar;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropMaxDegTree
extends Propagator<UndirectedGraphVar> {
    protected int n;
    protected int[] dMax;
    private int[] counter;
    private BitSet oneNode;
    private int[] list;

    public PropMaxDegTree(UndirectedGraphVar g, int[] maxDegrees) {
        super((Variable[])new UndirectedGraphVar[]{g}, PropagatorPriority.LINEAR, false);
        this.n = maxDegrees.length;
        this.oneNode = new BitSet(this.n);
        this.counter = new int[this.n];
        this.dMax = maxDegrees;
    }

    public int getPropagationConditions(int vIdx) {
        return GraphEventType.ADD_ARC.getMask();
    }

    public void propagate(int evtmask) throws ContradictionException {
        this.preprocessOneNodes();
        UndirectedGraphVar g = ((UndirectedGraphVar[])this.vars)[0];
        if (this.oneNode.cardinality() < this.n) {
            for (int i = 0; i < this.n; ++i) {
                ISet nei = g.getPotNeighOf(i);
                if (!this.oneNode.get(i)) continue;
                ISetIterator iSetIterator = nei.iterator();
                while (iSetIterator.hasNext()) {
                    int j = (Integer)iSetIterator.next();
                    if (!this.oneNode.get(j) || g.getMandNeighOf(i).contains(j)) continue;
                    g.removeArc(i, j, (ICause)this);
                }
            }
        }
    }

    private void preprocessOneNodes() throws ContradictionException {
        this.oneNode.clear();
        for (int i = 0; i < this.n; ++i) {
            this.counter[i] = 0;
        }
        UndirectedGraphVar g = ((UndirectedGraphVar[])this.vars)[0];
        int[] maxDegree = this.dMax;
        if (this.list == null) {
            this.list = new int[this.n];
        }
        int first = 0;
        int last = 0;
        for (int i = 0; i < this.n; ++i) {
            if (maxDegree[i] != 1) continue;
            this.list[last++] = i;
            this.oneNode.set(i);
        }
        while (first < last) {
            int k = this.list[first++];
            ISet nei = g.getMandNeighOf(k);
            ISetIterator iSetIterator = nei.iterator();
            while (iSetIterator.hasNext()) {
                int s = (Integer)iSetIterator.next();
                if (this.oneNode.get(s)) continue;
                int n = s;
                this.counter[n] = this.counter[n] + 1;
                if (this.counter[s] > maxDegree[s]) {
                    this.fails();
                    continue;
                }
                if (this.counter[s] != maxDegree[s] - 1) continue;
                this.oneNode.set(s);
                this.list[last++] = s;
            }
        }
    }

    public ESat isEntailed() {
        return ESat.TRUE;
    }
}

