/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.connectivity;

import org.chocosolver.graphsolver.util.StrongConnectivityFinder;
import org.chocosolver.graphsolver.variables.DirectedGraphVar;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropNbSCC
extends Propagator<Variable> {
    private DirectedGraphVar g;
    private IntVar k;
    private StrongConnectivityFinder env_CC_finder;
    private StrongConnectivityFinder ker_CC_finder;

    public PropNbSCC(DirectedGraphVar graph, IntVar k) {
        super(new Variable[]{graph, k}, PropagatorPriority.LINEAR, false);
        this.g = graph;
        this.k = k;
        this.env_CC_finder = new StrongConnectivityFinder((DirectedGraph)this.g.getUB());
        this.ker_CC_finder = new StrongConnectivityFinder((DirectedGraph)this.g.getLB());
    }

    public void propagate(int evtmask) throws ContradictionException {
        this.k.updateLowerBound(0, (ICause)this);
        if (this.g.getPotentialNodes().size() == 0) {
            this.k.instantiateTo(0, (ICause)this);
            return;
        }
        if (this.k.getUB() == 0) {
            ISetIterator iSetIterator = this.g.getPotentialNodes().iterator();
            while (iSetIterator.hasNext()) {
                int i = (Integer)iSetIterator.next();
                this.g.removeNode(i, (ICause)this);
            }
            return;
        }
        int min = this.minCC();
        int max = this.maxCC();
        this.k.updateLowerBound(min, (ICause)this);
        this.k.updateUpperBound(max, (ICause)this);
        if (this.k.getUB() == min && min != max) {
            int ccs = this.env_CC_finder.getNbSCC();
            boolean pot = true;
            for (int cc = 0; cc < ccs; ++cc) {
                int i = this.env_CC_finder.getSCCFirstNode(cc);
                while (i >= 0 && pot) {
                    if (this.g.getMandatoryNodes().contains(i)) {
                        pot = false;
                    }
                    i = this.env_CC_finder.getNextNode(i);
                }
                if (!pot) continue;
                i = this.env_CC_finder.getSCCFirstNode(cc);
                while (i >= 0) {
                    this.g.removeNode(i, (ICause)this);
                    i = this.env_CC_finder.getNextNode(i);
                }
            }
        }
    }

    public int minCC() {
        this.env_CC_finder.findAllSCC();
        int ccs = this.env_CC_finder.getNbSCC();
        int minCC = 0;
        block0: for (int cc = 0; cc < ccs; ++cc) {
            int i = this.env_CC_finder.getSCCFirstNode(cc);
            while (i >= 0) {
                if (this.g.getMandatoryNodes().contains(i)) {
                    ++minCC;
                    continue block0;
                }
                i = this.env_CC_finder.getNextNode(i);
            }
        }
        return minCC;
    }

    public int maxCC() {
        this.ker_CC_finder.findAllSCC();
        int nbK = this.ker_CC_finder.getNbSCC();
        int delta = this.g.getPotentialNodes().size() - this.g.getMandatoryNodes().size();
        return nbK + delta;
    }

    public ESat isEntailed() {
        if (this.k.getUB() < this.minCC() || this.k.getLB() > this.maxCC()) {
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

