/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.connectivity;

import org.chocosolver.graphsolver.util.ConnectivityFinder;
import org.chocosolver.graphsolver.variables.UndirectedGraphVar;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.graphs.IGraph;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropNbCC
extends Propagator<Variable> {
    private UndirectedGraphVar g;
    private IntVar k;
    private ConnectivityFinder env_CC_finder;
    private ConnectivityFinder ker_CC_finder;

    public PropNbCC(UndirectedGraphVar graph, IntVar k) {
        super(new Variable[]{graph, k}, PropagatorPriority.LINEAR, false);
        this.g = graph;
        this.k = k;
        this.env_CC_finder = new ConnectivityFinder((IGraph)this.g.getUB());
        this.ker_CC_finder = new ConnectivityFinder((IGraph)this.g.getLB());
    }

    public void propagate(int evtmask) throws ContradictionException {
        this.k.updateLowerBound(0, (ICause)this);
        if (this.g.getPotentialNodes().size() == 0) {
            this.k.instantiateTo(0, (ICause)this);
            return;
        }
        if (this.k.getUB() == 0) {
            ISetIterator iSetIterator = this.g.getPotentialNodes().iterator();
            while (iSetIterator.hasNext()) {
                int i = (Integer)iSetIterator.next();
                this.g.removeNode(i, (ICause)this);
            }
            return;
        }
        int min = this.minCC();
        int max = this.maxCC();
        this.k.updateLowerBound(min, (ICause)this);
        this.k.updateUpperBound(max, (ICause)this);
        if (this.k.getUB() == min && min != max) {
            int ccs = this.env_CC_finder.getNBCC();
            boolean pot = true;
            for (int cc = 0; cc < ccs; ++cc) {
                int i = this.env_CC_finder.getCC_firstNode()[cc];
                while (i >= 0 && pot) {
                    if (this.g.getMandatoryNodes().contains(i)) {
                        pot = false;
                    }
                    i = this.env_CC_finder.getCC_nextNode()[i];
                }
                if (!pot) continue;
                i = this.env_CC_finder.getCC_firstNode()[cc];
                while (i >= 0) {
                    this.g.removeNode(i, (ICause)this);
                    i = this.env_CC_finder.getCC_nextNode()[i];
                }
            }
        }
        if (this.k.isInstantiatedTo(1) && this.g.getMandatoryNodes().size() == this.g.getPotentialNodes().size()) {
            if (!this.env_CC_finder.isConnectedAndFindIsthma()) {
                throw new UnsupportedOperationException("connectivity has been checked");
            }
            int nbIsma = this.env_CC_finder.isthmusFrom.size();
            for (int i = 0; i < nbIsma; ++i) {
                this.g.enforceArc(this.env_CC_finder.isthmusFrom.get(i), this.env_CC_finder.isthmusTo.get(i), (ICause)this);
            }
        }
    }

    public int minCC() {
        this.env_CC_finder.findAllCC();
        int ccs = this.env_CC_finder.getNBCC();
        int minCC = 0;
        block0: for (int cc = 0; cc < ccs; ++cc) {
            int i = this.env_CC_finder.getCC_firstNode()[cc];
            while (i >= 0) {
                if (this.g.getMandatoryNodes().contains(i)) {
                    ++minCC;
                    continue block0;
                }
                i = this.env_CC_finder.getCC_nextNode()[i];
            }
        }
        return minCC;
    }

    public int maxCC() {
        this.ker_CC_finder.findAllCC();
        int nbK = this.ker_CC_finder.getNBCC();
        int delta = this.g.getPotentialNodes().size() - this.g.getMandatoryNodes().size();
        return nbK + delta;
    }

    public ESat isEntailed() {
        if (this.k.getUB() < this.minCC() || this.k.getLB() > this.maxCC()) {
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

