/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.connectivity;

import java.util.BitSet;
import org.chocosolver.graphsolver.util.ConnectivityFinder;
import org.chocosolver.graphsolver.variables.GraphEventType;
import org.chocosolver.graphsolver.variables.UndirectedGraphVar;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.graphs.IGraph;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropConnected
extends Propagator<UndirectedGraphVar> {
    private int n;
    private BitSet visited;
    private int[] fifo;
    private UndirectedGraphVar g;
    private ConnectivityFinder env_CC_finder;
    private boolean checkerOnly;

    public PropConnected(UndirectedGraphVar graph) {
        this(graph, false);
    }

    public PropConnected(UndirectedGraphVar graph, boolean checkerOnly) {
        super((Variable[])new UndirectedGraphVar[]{graph}, PropagatorPriority.LINEAR, false);
        this.g = graph;
        this.n = graph.getNbMaxNodes();
        this.visited = new BitSet(this.n);
        this.fifo = new int[this.n];
        this.env_CC_finder = new ConnectivityFinder((IGraph)this.g.getUB());
        this.checkerOnly = checkerOnly;
    }

    public int getPropagationConditions(int vIdx) {
        return GraphEventType.REMOVE_ARC.getMask() + GraphEventType.ADD_NODE.getMask() + GraphEventType.REMOVE_NODE.getMask();
    }

    public void propagate(int evtmask) throws ContradictionException {
        if (this.g.getPotentialNodes().size() == 0) {
            this.fails();
        }
        if (this.g.getMandatoryNodes().size() > 1) {
            this.explore();
            int o = this.visited.nextClearBit(0);
            while (o < this.n) {
                this.g.removeNode(o, (ICause)this);
                o = this.visited.nextClearBit(o + 1);
            }
            if (this.g.getMandatoryNodes().size() == this.g.getPotentialNodes().size() && !this.checkerOnly) {
                if (!this.env_CC_finder.isConnectedAndFindIsthma()) {
                    throw new UnsupportedOperationException("connectivity has been checked");
                }
                int nbIsma = this.env_CC_finder.isthmusFrom.size();
                for (int i = 0; i < nbIsma; ++i) {
                    this.g.enforceArc(this.env_CC_finder.isthmusFrom.get(i), this.env_CC_finder.isthmusTo.get(i), (ICause)this);
                }
            }
        }
    }

    public ESat isEntailed() {
        if (this.g.getPotentialNodes().size() == 1) {
            return ESat.TRUE;
        }
        if (this.g.getMandatoryNodes().size() == 0) {
            return ESat.FALSE;
        }
        this.explore();
        ISetIterator iSetIterator = this.g.getMandatoryNodes().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            if (this.visited.get(i)) continue;
            return ESat.FALSE;
        }
        if (!this.g.isInstantiated()) {
            return ESat.UNDEFINED;
        }
        return ESat.TRUE;
    }

    private void explore() {
        this.visited.clear();
        int first = 0;
        int last = 0;
        if (this.g.getMandatoryNodes().size() <= 0) {
            return;
        }
        int i = this.g.getMandatoryNodes().iterator().next();
        this.fifo[last++] = i;
        this.visited.set(i);
        while (first < last) {
            i = this.fifo[first++];
            ISetIterator iSetIterator = this.g.getPotNeighOf(i).iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (this.visited.get(j)) continue;
                this.visited.set(j);
                this.fifo[last++] = j;
            }
        }
    }
}

