/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.connectivity;

import org.chocosolver.graphsolver.util.ConnectivityFinder;
import org.chocosolver.graphsolver.variables.GraphEventType;
import org.chocosolver.graphsolver.variables.UndirectedGraphVar;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.graphs.IGraph;

public class PropBiconnected
extends Propagator<UndirectedGraphVar> {
    private UndirectedGraphVar g;
    private ConnectivityFinder env_CC_finder;

    public PropBiconnected(UndirectedGraphVar graph) {
        super((Variable[])new UndirectedGraphVar[]{graph}, PropagatorPriority.LINEAR, false);
        this.g = graph;
        this.env_CC_finder = new ConnectivityFinder((IGraph)this.g.getUB());
    }

    public void propagate(int evtmask) throws ContradictionException {
        if (this.g.getPotentialNodes().size() == this.g.getMandatoryNodes().size() && !this.env_CC_finder.isBiconnected()) {
            this.fails();
        }
    }

    public int getPropagationConditions(int vIdx) {
        return GraphEventType.REMOVE_NODE.getMask() + GraphEventType.REMOVE_ARC.getMask() + GraphEventType.ADD_NODE.getMask();
    }

    public ESat isEntailed() {
        if (this.g.getPotentialNodes().size() == this.g.getMandatoryNodes().size()) {
            return ESat.UNDEFINED;
        }
        if (!this.env_CC_finder.isBiconnected()) {
            return ESat.FALSE;
        }
        if (this.g.isInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

