/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.channeling.nodes;

import org.chocosolver.graphsolver.variables.GraphEventType;
import org.chocosolver.graphsolver.variables.GraphVar;
import org.chocosolver.graphsolver.variables.delta.GraphDeltaMonitor;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.IntProcedure;

public class PropNodeSetChannel
extends Propagator<Variable> {
    private SetVar set;
    private GraphVar g;
    private ISetDeltaMonitor sdm;
    private GraphDeltaMonitor gdm;
    private IntProcedure forceG;
    private IntProcedure forceS;
    private IntProcedure remG;
    private IntProcedure remS;

    public PropNodeSetChannel(SetVar vertexSet, GraphVar gV) {
        super(new Variable[]{vertexSet, gV}, PropagatorPriority.LINEAR, true);
        this.set = vertexSet;
        this.g = gV;
        this.sdm = this.set.monitorDelta((ICause)this);
        this.gdm = this.g.monitorDelta((ICause)this);
        this.forceS = element -> this.g.enforceNode(element, (ICause)this);
        this.remS = element -> this.g.removeNode(element, (ICause)this);
        this.forceG = element -> this.set.force(element, (ICause)this);
        this.remG = element -> this.set.remove(element, (ICause)this);
    }

    public int getPropagationConditions(int vIdx) {
        if (vIdx == 0) {
            return SetEventType.ADD_TO_KER.getMask() + SetEventType.REMOVE_FROM_ENVELOPE.getMask();
        }
        return GraphEventType.ADD_NODE.getMask() + GraphEventType.REMOVE_NODE.getMask();
    }

    public void propagate(int evtmask) throws ContradictionException {
        int i;
        ISetIterator iSetIterator = this.set.getUB().iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            if (this.g.getMandatoryNodes().contains(i)) {
                this.set.force(i, (ICause)this);
                continue;
            }
            if (this.g.getPotentialNodes().contains(i)) continue;
            this.set.remove(i, (ICause)this);
        }
        iSetIterator = this.g.getPotentialNodes().iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            if (this.set.getLB().contains(i)) {
                this.g.enforceNode(i, (ICause)this);
                continue;
            }
            if (this.set.getUB().contains(i)) continue;
            this.g.removeNode(i, (ICause)this);
        }
        this.gdm.unfreeze();
        this.sdm.unfreeze();
    }

    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (idxVarInProp == 0) {
            this.sdm.freeze();
            this.sdm.forEach(this.forceS, SetEventType.ADD_TO_KER);
            this.sdm.forEach(this.remS, SetEventType.REMOVE_FROM_ENVELOPE);
            this.sdm.unfreeze();
        } else {
            this.gdm.freeze();
            this.gdm.forEachNode(this.forceG, GraphEventType.ADD_NODE);
            this.gdm.forEachNode(this.remG, GraphEventType.REMOVE_NODE);
            this.gdm.unfreeze();
        }
    }

    public ESat isEntailed() {
        int i;
        ISetIterator iSetIterator = this.set.getLB().iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            if (this.g.getPotentialNodes().contains(i)) continue;
            return ESat.FALSE;
        }
        iSetIterator = this.g.getMandatoryNodes().iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            if (this.set.getUB().contains(i)) continue;
            return ESat.FALSE;
        }
        int n = this.g.getMandatoryNodes().size();
        if (n == this.g.getPotentialNodes().size() && n == this.set.getUB().size() && n == this.set.getLB().size()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

