/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.channeling.nodes;

import org.chocosolver.graphsolver.variables.GraphEventType;
import org.chocosolver.graphsolver.variables.GraphVar;
import org.chocosolver.graphsolver.variables.delta.GraphDeltaMonitor;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.tools.ArrayUtils;

public class PropNodeBoolsChannel
extends Propagator<Variable> {
    private BoolVar[] bools;
    private GraphVar g;
    private GraphDeltaMonitor gdm;
    private IntProcedure remG;
    private IntProcedure forceG;

    public PropNodeBoolsChannel(BoolVar[] vertices, GraphVar gV) {
        super((Variable[])ArrayUtils.append((Object[][])new Variable[][]{vertices, {gV}}), PropagatorPriority.LINEAR, true);
        this.bools = vertices;
        this.g = gV;
        this.gdm = this.g.monitorDelta((ICause)this);
        this.forceG = element -> this.bools[element].setToTrue((ICause)this);
        this.remG = element -> this.bools[element].setToFalse((ICause)this);
        super.linkVariables();
    }

    public int getPropagationConditions(int vIdx) {
        if (vIdx == this.bools.length) {
            return GraphEventType.ADD_NODE.getMask() + GraphEventType.REMOVE_NODE.getMask();
        }
        return IntEventType.all();
    }

    public void propagate(int evtmask) throws ContradictionException {
        for (int i = 0; i < this.bools.length; ++i) {
            if (!this.g.getPotentialNodes().contains(i)) {
                this.bools[i].setToFalse((ICause)this);
                continue;
            }
            if (!this.g.getMandatoryNodes().contains(i)) continue;
            this.bools[i].setToTrue((ICause)this);
        }
        ISetIterator iSetIterator = this.g.getPotentialNodes().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            if (!this.bools[i].contains(1)) {
                this.g.removeNode(i, (ICause)this);
                continue;
            }
            if (this.bools[i].getLB() != 1) continue;
            this.g.enforceNode(i, (ICause)this);
        }
        this.gdm.unfreeze();
    }

    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (idxVarInProp < this.bools.length) {
            if (this.bools[idxVarInProp].getValue() == 1) {
                this.g.enforceNode(idxVarInProp, (ICause)this);
            } else {
                this.g.removeNode(idxVarInProp, (ICause)this);
            }
        } else {
            this.gdm.freeze();
            this.gdm.forEachNode(this.forceG, GraphEventType.ADD_NODE);
            this.gdm.forEachNode(this.remG, GraphEventType.REMOVE_NODE);
            this.gdm.unfreeze();
        }
    }

    public ESat isEntailed() {
        for (int i = 0; i < this.bools.length; ++i) {
            if (this.bools[i].getLB() == 1 && !this.g.getPotentialNodes().contains(i)) {
                return ESat.FALSE;
            }
            if (this.bools[i].getUB() != 0 || !this.g.getMandatoryNodes().contains(i)) continue;
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

