/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.channeling.nodes;

import org.chocosolver.graphsolver.variables.GraphEventType;
import org.chocosolver.graphsolver.variables.GraphVar;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public class PropNodeBoolChannel
extends Propagator<Variable> {
    private BoolVar bool;
    private int vertex;
    private GraphVar g;

    public PropNodeBoolChannel(BoolVar isIn, int vertex, GraphVar gV) {
        super(new Variable[]{isIn, gV}, PropagatorPriority.UNARY, false);
        this.bool = isIn;
        this.vertex = vertex;
        this.g = gV;
    }

    public int getPropagationConditions(int vIdx) {
        if (vIdx == 1) {
            return GraphEventType.ADD_NODE.getMask() + GraphEventType.REMOVE_NODE.getMask();
        }
        return IntEventType.all();
    }

    public void propagate(int evtmask) throws ContradictionException {
        if (this.vertex < 0 || this.vertex >= this.g.getNbMaxNodes() || !this.g.getPotentialNodes().contains(this.vertex)) {
            this.bool.setToFalse((ICause)this);
        } else if (this.g.getMandatoryNodes().contains(this.vertex)) {
            this.bool.setToTrue((ICause)this);
        } else if (this.bool.getLB() == 1) {
            this.g.enforceNode(this.vertex, (ICause)this);
        } else if (this.bool.getUB() == 0) {
            this.g.removeNode(this.vertex, (ICause)this);
        }
    }

    public ESat isEntailed() {
        if (this.vertex < 0 || this.vertex >= this.g.getNbMaxNodes() || this.bool.getLB() == 1 && !this.g.getPotentialNodes().contains(this.vertex) || this.bool.getUB() == 0 && this.g.getMandatoryNodes().contains(this.vertex)) {
            return ESat.FALSE;
        }
        if (this.bool.isInstantiated() && this.g.getMandatoryNodes().contains(this.vertex) == this.g.getPotentialNodes().contains(this.vertex)) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

