/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.channeling.edges;

import org.chocosolver.graphsolver.variables.DirectedGraphVar;
import org.chocosolver.graphsolver.variables.GraphEventType;
import org.chocosolver.graphsolver.variables.delta.GraphDeltaMonitor;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.PairProcedure;

public class PropSuccIntsChannel1
extends Propagator<DirectedGraphVar> {
    private int n;
    private IntVar[] succs;
    private GraphDeltaMonitor gdm;
    private DirectedGraphVar g;
    private PairProcedure arcForced;
    private PairProcedure arcRemoved;

    public PropSuccIntsChannel1(IntVar[] succs, DirectedGraphVar gV) {
        super((Variable[])new DirectedGraphVar[]{gV}, PropagatorPriority.LINEAR, true);
        this.succs = succs;
        this.n = succs.length;
        this.g = gV;
        assert (this.n == this.g.getNbMaxNodes());
        this.gdm = this.g.monitorDelta((ICause)this);
        for (int i2 = 0; i2 < this.n; ++i2) {
            assert (succs[i2].hasEnumeratedDomain()) : "channeling variables should be enumerated";
        }
        this.arcForced = (i, j) -> succs[i].instantiateTo(j, (ICause)this);
        this.arcRemoved = (i, j) -> succs[i].removeValue(j, (ICause)this);
    }

    public void propagate(int evtmask) throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            ISet tmp = this.g.getMandSuccOrNeighOf(i);
            ISetIterator iSetIterator = tmp.iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                this.succs[i].instantiateTo(j, (ICause)this);
            }
            int j = this.succs[i].getLB();
            while (j <= this.succs[i].getUB()) {
                if (!this.g.getPotSuccOrNeighOf(i).contains(j)) {
                    this.succs[i].removeValue(j, (ICause)this);
                }
                j = this.succs[i].nextValue(j);
            }
        }
        this.gdm.unfreeze();
    }

    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.gdm.freeze();
        this.gdm.forEachArc(this.arcForced, GraphEventType.ADD_ARC);
        this.gdm.forEachArc(this.arcRemoved, GraphEventType.REMOVE_ARC);
        this.gdm.unfreeze();
    }

    public ESat isEntailed() {
        for (int i = 0; i < this.n; ++i) {
            if (this.succs[i].isInstantiated() && !this.g.getPotSuccOrNeighOf(i).contains(this.succs[i].getValue())) {
                return ESat.FALSE;
            }
            ISet tmp = this.g.getMandSuccOrNeighOf(i);
            ISetIterator iSetIterator = tmp.iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (this.succs[i].contains(j)) continue;
                return ESat.FALSE;
            }
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

