/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.channeling.edges;

import org.chocosolver.graphsolver.variables.GraphVar;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.IntProcedure;

public class PropNeighSetsChannel2
extends Propagator<SetVar> {
    private int n;
    private int currentSet;
    private ISetDeltaMonitor[] sdm;
    private SetVar[] sets;
    private GraphVar g;
    private IntProcedure elementForced;
    private IntProcedure elementRemoved;

    public PropNeighSetsChannel2(SetVar[] setsV, GraphVar gV) {
        super((Variable[])setsV, PropagatorPriority.LINEAR, true);
        this.sets = new SetVar[setsV.length];
        System.arraycopy(this.vars, 0, this.sets, 0, setsV.length);
        this.n = this.sets.length;
        this.g = gV;
        assert (this.n == this.g.getNbMaxNodes());
        this.sdm = new ISetDeltaMonitor[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.sdm[i] = this.sets[i].monitorDelta((ICause)this);
        }
        this.elementForced = element -> this.g.enforceArc(this.currentSet, element, (ICause)this);
        this.elementRemoved = element -> this.g.removeArc(this.currentSet, element, (ICause)this);
    }

    public void propagate(int evtmask) throws ContradictionException {
        int i;
        for (i = 0; i < this.n; ++i) {
            ISetIterator iSetIterator = this.sets[i].getLB().iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                this.g.enforceArc(i, j, (ICause)this);
            }
            ISet tmp = this.g.getPotSuccOrNeighOf(i);
            ISetIterator iSetIterator2 = tmp.iterator();
            while (iSetIterator2.hasNext()) {
                int j = (Integer)iSetIterator2.next();
                if (this.sets[i].getUB().contains(j)) continue;
                this.g.removeArc(i, j, (ICause)this);
            }
        }
        for (i = 0; i < this.n; ++i) {
            this.sdm[i].unfreeze();
        }
    }

    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.currentSet = idxVarInProp;
        this.sdm[this.currentSet].freeze();
        this.sdm[this.currentSet].forEach(this.elementForced, SetEventType.ADD_TO_KER);
        this.sdm[this.currentSet].forEach(this.elementRemoved, SetEventType.REMOVE_FROM_ENVELOPE);
        this.sdm[this.currentSet].unfreeze();
    }

    public ESat isEntailed() {
        for (int i = 0; i < this.n; ++i) {
            ISetIterator iSetIterator = this.sets[i].getLB().iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (this.g.getPotSuccOrNeighOf(i).contains(j)) continue;
                return ESat.FALSE;
            }
            ISet tmp = this.g.getMandSuccOrNeighOf(i);
            ISetIterator iSetIterator2 = tmp.iterator();
            while (iSetIterator2.hasNext()) {
                int j = (Integer)iSetIterator2.next();
                if (this.sets[i].getUB().contains(j)) continue;
                return ESat.FALSE;
            }
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

