/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.channeling.edges;

import org.chocosolver.graphsolver.variables.GraphEventType;
import org.chocosolver.graphsolver.variables.GraphVar;
import org.chocosolver.graphsolver.variables.delta.GraphDeltaMonitor;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.PairProcedure;

public class PropNeighSetsChannel1
extends Propagator<GraphVar> {
    private int n;
    private SetVar[] sets;
    private GraphDeltaMonitor gdm;
    private GraphVar g;
    private PairProcedure arcForced;
    private PairProcedure arcRemoved;

    public PropNeighSetsChannel1(SetVar[] setsV, GraphVar gV) {
        super((Variable[])new GraphVar[]{gV}, PropagatorPriority.LINEAR, true);
        this.sets = setsV;
        this.n = this.sets.length;
        this.g = gV;
        assert (this.n == this.g.getNbMaxNodes());
        this.gdm = this.g.monitorDelta((ICause)this);
        this.arcForced = (i, j) -> {
            this.sets[i].force(j, (ICause)this);
            if (!this.g.isDirected()) {
                this.sets[j].force(i, (ICause)this);
            }
        };
        this.arcRemoved = (i, j) -> {
            this.sets[i].remove(j, (ICause)this);
            if (!this.g.isDirected()) {
                this.sets[j].remove(i, (ICause)this);
            }
        };
    }

    public void propagate(int evtmask) throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            int j;
            ISet tmp = this.g.getMandSuccOrNeighOf(i);
            ISetIterator iSetIterator = tmp.iterator();
            while (iSetIterator.hasNext()) {
                j = (Integer)iSetIterator.next();
                this.sets[i].force(j, (ICause)this);
                if (this.g.isDirected()) continue;
                this.sets[j].force(i, (ICause)this);
            }
            iSetIterator = this.sets[i].getUB().iterator();
            while (iSetIterator.hasNext()) {
                j = (Integer)iSetIterator.next();
                if (this.g.getPotSuccOrNeighOf(i).contains(j)) continue;
                this.sets[i].remove(j, (ICause)this);
                if (this.g.isDirected()) continue;
                this.sets[j].remove(i, (ICause)this);
            }
        }
        this.gdm.unfreeze();
    }

    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.gdm.freeze();
        this.gdm.forEachArc(this.arcForced, GraphEventType.ADD_ARC);
        this.gdm.forEachArc(this.arcRemoved, GraphEventType.REMOVE_ARC);
        this.gdm.unfreeze();
    }

    public ESat isEntailed() {
        for (int i = 0; i < this.n; ++i) {
            ISetIterator iSetIterator = this.sets[i].getLB().iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (this.g.getPotSuccOrNeighOf(i).contains(j)) continue;
                return ESat.FALSE;
            }
            ISet tmp = this.g.getMandSuccOrNeighOf(i);
            ISetIterator iSetIterator2 = tmp.iterator();
            while (iSetIterator2.hasNext()) {
                int j = (Integer)iSetIterator2.next();
                if (this.sets[i].getUB().contains(j)) continue;
                return ESat.FALSE;
            }
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

