/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.channeling.edges;

import org.chocosolver.graphsolver.variables.GraphEventType;
import org.chocosolver.graphsolver.variables.GraphVar;
import org.chocosolver.graphsolver.variables.IncidentSet;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.IntProcedure;

public class PropNeighSetChannel
extends Propagator<Variable> {
    private SetVar set;
    private GraphVar g;
    private int vertex;
    private IncidentSet inc;
    private ISetDeltaMonitor sdm;
    private IntProcedure forceS;
    private IntProcedure remS;

    public PropNeighSetChannel(SetVar neigh, int vertex, GraphVar gV, IncidentSet incSet) {
        super(new Variable[]{neigh, gV}, PropagatorPriority.LINEAR, true);
        this.vertex = vertex;
        this.set = neigh;
        this.g = gV;
        this.inc = incSet;
        this.sdm = this.set.monitorDelta((ICause)this);
        this.forceS = element -> this.inc.enforce(this.g, vertex, element, (ICause)this);
        this.remS = element -> this.inc.remove(this.g, vertex, element, (ICause)this);
    }

    public int getPropagationConditions(int vIdx) {
        if (vIdx == 0) {
            return SetEventType.ADD_TO_KER.getMask() + SetEventType.REMOVE_FROM_ENVELOPE.getMask();
        }
        return GraphEventType.ADD_ARC.getMask() + GraphEventType.REMOVE_ARC.getMask();
    }

    public void propagate(int evtmask) throws ContradictionException {
        int i;
        ISetIterator iSetIterator = this.inc.getPotSet(this.g, this.vertex).iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            if (!this.set.getUB().contains(i)) {
                this.inc.remove(this.g, this.vertex, i, (ICause)this);
                continue;
            }
            if (!this.set.getLB().contains(i)) continue;
            this.inc.enforce(this.g, this.vertex, i, (ICause)this);
        }
        iSetIterator = this.set.getUB().iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            if (!this.inc.getPotSet(this.g, this.vertex).contains(i)) {
                this.set.remove(i, (ICause)this);
                continue;
            }
            if (!this.inc.getMandSet(this.g, this.vertex).contains(i)) continue;
            this.set.force(i, (ICause)this);
        }
        this.sdm.unfreeze();
    }

    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (idxVarInProp == 0) {
            this.sdm.freeze();
            this.sdm.forEach(this.forceS, SetEventType.ADD_TO_KER);
            this.sdm.forEach(this.remS, SetEventType.REMOVE_FROM_ENVELOPE);
            this.sdm.unfreeze();
        } else {
            ISetIterator iSetIterator = this.set.getUB().iterator();
            while (iSetIterator.hasNext()) {
                int i = (Integer)iSetIterator.next();
                if (!this.inc.getPotSet(this.g, this.vertex).contains(i)) {
                    this.set.remove(i, (ICause)this);
                    continue;
                }
                if (!this.inc.getMandSet(this.g, this.vertex).contains(i)) continue;
                this.set.force(i, (ICause)this);
            }
        }
    }

    public ESat isEntailed() {
        int i;
        ISetIterator iSetIterator = this.set.getLB().iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            if (this.inc.getPotSet(this.g, this.vertex).contains(i)) continue;
            return ESat.FALSE;
        }
        iSetIterator = this.inc.getMandSet(this.g, this.vertex).iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            if (this.set.getUB().contains(i)) continue;
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

