/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.channeling.edges;

import org.chocosolver.graphsolver.variables.GraphVar;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.IntProcedure;

public class PropNeighIntsChannel2
extends Propagator<IntVar> {
    private int n;
    private int currentSet;
    private IIntDeltaMonitor[] idm;
    private IntVar[] succs;
    private GraphVar g;
    private IntProcedure elementRemoved;
    private boolean dir;

    public PropNeighIntsChannel2(IntVar[] succs, GraphVar gV) {
        super((Variable[])succs, PropagatorPriority.LINEAR, true);
        this.succs = succs;
        this.n = succs.length;
        this.g = gV;
        assert (this.n == this.g.getNbMaxNodes());
        this.dir = this.g.isDirected();
        this.idm = new IIntDeltaMonitor[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.idm[i] = succs[i].monitorDelta((ICause)this);
        }
        this.elementRemoved = element -> {
            if (this.dir || !succs[element].contains(this.currentSet)) {
                this.g.removeArc(this.currentSet, element, (ICause)this);
            }
        };
    }

    public void propagate(int evtmask) throws ContradictionException {
        int i;
        for (i = 0; i < this.n; ++i) {
            this.g.enforceNode(i, (ICause)this);
            if (this.succs[i].isInstantiated()) {
                this.g.enforceArc(i, this.succs[i].getValue(), (ICause)this);
            }
            ISet tmp = this.g.getPotSuccOrNeighOf(i);
            ISetIterator iSetIterator = tmp.iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (this.succs[i].contains(j) || !this.dir && this.succs[j].contains(i)) continue;
                this.g.removeArc(i, j, (ICause)this);
            }
        }
        for (i = 0; i < this.n; ++i) {
            this.idm[i].unfreeze();
        }
    }

    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.currentSet = idxVarInProp;
        this.idm[this.currentSet].freeze();
        if (((IntVar[])this.vars)[idxVarInProp].isInstantiated()) {
            this.g.enforceArc(idxVarInProp, ((IntVar[])this.vars)[idxVarInProp].getValue(), (ICause)this);
        }
        this.idm[this.currentSet].forEachRemVal(this.elementRemoved);
        this.idm[this.currentSet].unfreeze();
    }

    public ESat isEntailed() {
        for (int i = 0; i < this.n; ++i) {
            if (this.succs[i].isInstantiated() && !this.g.getPotSuccOrNeighOf(i).contains(this.succs[i].getValue())) {
                return ESat.FALSE;
            }
            ISet tmp = this.g.getMandSuccOrNeighOf(i);
            ISetIterator iSetIterator = tmp.iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (this.succs[i].contains(j) || !this.g.isDirected() && this.succs[j].contains(i)) continue;
                return ESat.FALSE;
            }
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

