/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.channeling.edges;

import org.chocosolver.graphsolver.variables.UndirectedGraphVar;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropNeighIntsChannel1
extends Propagator<UndirectedGraphVar> {
    private int n;
    private IntVar[] succs;
    private UndirectedGraphVar g;

    public PropNeighIntsChannel1(IntVar[] succs, UndirectedGraphVar gV) {
        super((Variable[])new UndirectedGraphVar[]{gV}, PropagatorPriority.LINEAR, false);
        this.succs = succs;
        this.n = succs.length;
        this.g = gV;
        assert (this.n == this.g.getNbMaxNodes());
        for (int i = 0; i < this.n; ++i) {
            assert (succs[i].hasEnumeratedDomain()) : "channeling variables should be enumerated";
        }
    }

    public void propagate(int evtmask) throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            ISet tmp = this.g.getMandNeighOf(i);
            ISetIterator iSetIterator = tmp.iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (!this.succs[i].contains(j)) {
                    this.succs[j].instantiateTo(i, (ICause)this);
                    continue;
                }
                if (this.succs[j].contains(i)) continue;
                this.succs[i].instantiateTo(j, (ICause)this);
            }
            int j = this.succs[i].getLB();
            while (j <= this.succs[i].getUB()) {
                if (!this.g.getPotNeighOf(i).contains(j)) {
                    this.succs[i].removeValue(j, (ICause)this);
                }
                j = this.succs[i].nextValue(j);
            }
        }
    }

    public ESat isEntailed() {
        for (int i = 0; i < this.n; ++i) {
            if (this.succs[i].isInstantiated() && !this.g.getPotNeighOf(i).contains(this.succs[i].getValue())) {
                return ESat.FALSE;
            }
            ISet tmp = this.g.getMandNeighOf(i);
            ISetIterator iSetIterator = tmp.iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (this.succs[i].contains(j) || this.succs[j].contains(i)) continue;
                return ESat.FALSE;
            }
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

