/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.channeling.edges;

import org.chocosolver.graphsolver.variables.GraphVar;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropNeighBoolsChannel2
extends Propagator<BoolVar> {
    private int n;
    private BoolVar[][] matrix;
    private GraphVar g;

    public PropNeighBoolsChannel2(BoolVar[][] adjacencyMatrix, GraphVar gV) {
        super((Variable[])ArrayUtils.flatten((Object[][])adjacencyMatrix), PropagatorPriority.LINEAR, false);
        this.matrix = adjacencyMatrix;
        this.n = adjacencyMatrix.length;
        assert (this.n == adjacencyMatrix[0].length);
        this.g = gV;
        assert (this.n == this.g.getNbMaxNodes());
    }

    public void propagate(int evtmask) throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (this.matrix[i][j].getLB() == 1) {
                    this.g.enforceArc(i, j, (ICause)this);
                    continue;
                }
                if (this.matrix[i][j].getUB() != 0) continue;
                this.g.removeArc(i, j, (ICause)this);
            }
        }
    }

    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        int i = idxVarInProp / this.n;
        int j = idxVarInProp % this.n;
        if (this.matrix[i][j].getLB() == 1) {
            this.g.enforceArc(i, j, (ICause)this);
        } else {
            this.g.removeArc(i, j, (ICause)this);
        }
    }

    public ESat isEntailed() {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (this.matrix[i][j].getLB() == 1 && !this.g.getPotSuccOrNeighOf(i).contains(j)) {
                    return ESat.FALSE;
                }
                if (this.matrix[i][j].getUB() != 0 || !this.g.getMandSuccOrNeighOf(i).contains(j)) continue;
                return ESat.FALSE;
            }
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

