/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.graphsolver.cstrs.channeling.edges;

import org.chocosolver.graphsolver.variables.GraphEventType;
import org.chocosolver.graphsolver.variables.GraphVar;
import org.chocosolver.graphsolver.variables.delta.GraphDeltaMonitor;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.procedure.PairProcedure;

public class PropNeighBoolsChannel1
extends Propagator<GraphVar> {
    private int n;
    private BoolVar[][] matrix;
    private GraphDeltaMonitor gdm;
    private GraphVar g;
    private PairProcedure arcForced;
    private PairProcedure arcRemoved;

    public PropNeighBoolsChannel1(BoolVar[][] adjacencyMatrix, GraphVar gV) {
        super((Variable[])new GraphVar[]{gV}, PropagatorPriority.LINEAR, true);
        this.matrix = adjacencyMatrix;
        this.n = this.matrix.length;
        assert (this.n == this.matrix[0].length);
        this.g = gV;
        assert (this.n == this.g.getNbMaxNodes());
        this.gdm = this.g.monitorDelta((ICause)this);
        this.arcForced = (i, j) -> {
            this.matrix[i][j].setToTrue((ICause)this);
            if (!this.g.isDirected()) {
                this.matrix[j][i].setToTrue((ICause)this);
            }
        };
        this.arcRemoved = (i, j) -> {
            this.matrix[i][j].setToFalse((ICause)this);
            if (!this.g.isDirected()) {
                this.matrix[j][i].setToFalse((ICause)this);
            }
        };
    }

    public void propagate(int evtmask) throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (this.g.getMandSuccOrNeighOf(i).contains(j)) {
                    this.matrix[i][j].setToTrue((ICause)this);
                    continue;
                }
                if (this.g.getPotSuccOrNeighOf(i).contains(j)) continue;
                this.matrix[i][j].setToFalse((ICause)this);
            }
        }
        this.gdm.unfreeze();
    }

    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.gdm.freeze();
        this.gdm.forEachArc(this.arcForced, GraphEventType.ADD_ARC);
        this.gdm.forEachArc(this.arcRemoved, GraphEventType.REMOVE_ARC);
        this.gdm.unfreeze();
    }

    public ESat isEntailed() {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (this.matrix[i][j].getLB() == 1 && !this.g.getPotSuccOrNeighOf(i).contains(j)) {
                    return ESat.FALSE;
                }
                if (this.matrix[i][j].getUB() != 0 || !this.g.getMandSuccOrNeighOf(i).contains(j)) continue;
                return ESat.FALSE;
            }
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

